/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.pkix.params.x509certificate.extension;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x509.GeneralName;
import org.xwiki.crypto.pkix.internal.extension.BcGeneralName;
import org.xwiki.crypto.pkix.params.x509certificate.extension.X509StringGeneralName;
import org.xwiki.stability.Unstable;

@Unstable
public class X509Rfc822Name
implements X509StringGeneralName,
BcGeneralName {
    private final String str;
    private final InternetAddress addr;

    public X509Rfc822Name(String address) {
        String newStr = null;
        InternetAddress newAddr = null;
        try {
            newAddr = new InternetAddress(address);
            newStr = newAddr.getAddress();
        }
        catch (AddressException e) {
            newStr = address;
        }
        this.str = newStr;
        this.addr = newAddr;
    }

    public X509Rfc822Name(InternetAddress address) {
        this.addr = address;
        this.str = address.getAddress();
    }

    public X509Rfc822Name(GeneralName name) {
        this(DERIA5String.getInstance((Object)name.getName()).getString());
        if (name.getTagNo() != 1) {
            throw new IllegalArgumentException("Incompatible general name: " + name.getTagNo());
        }
    }

    public InternetAddress getAddress() {
        return this.addr;
    }

    @Override
    public String getName() {
        return this.str;
    }

    @Override
    public GeneralName getGeneralName() {
        return new GeneralName(1, this.str);
    }
}

