/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.script;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.KeyPairGenerator;
import org.xwiki.crypto.params.cipher.CipherParameters;
import org.xwiki.crypto.params.cipher.asymmetric.AsymmetricKeyPair;
import org.xwiki.crypto.params.cipher.asymmetric.PrivateKeyParameters;
import org.xwiki.crypto.params.cipher.asymmetric.PublicKeyParameters;
import org.xwiki.crypto.params.generator.KeyGenerationParameters;
import org.xwiki.crypto.params.generator.asymmetric.RSAKeyGenerationParameters;
import org.xwiki.crypto.pkix.CertificateChainBuilder;
import org.xwiki.crypto.pkix.CertificateGeneratorFactory;
import org.xwiki.crypto.pkix.CertificateProvider;
import org.xwiki.crypto.pkix.CertifyingSigner;
import org.xwiki.crypto.pkix.X509ExtensionBuilder;
import org.xwiki.crypto.pkix.params.CertificateGenerationParameters;
import org.xwiki.crypto.pkix.params.CertificateParameters;
import org.xwiki.crypto.pkix.params.CertifiedKeyPair;
import org.xwiki.crypto.pkix.params.CertifiedPublicKey;
import org.xwiki.crypto.pkix.params.PrincipalIndentifier;
import org.xwiki.crypto.pkix.params.x509certificate.DistinguishedName;
import org.xwiki.crypto.pkix.params.x509certificate.X509CertificateGenerationParameters;
import org.xwiki.crypto.pkix.params.x509certificate.X509CertificateParameters;
import org.xwiki.crypto.pkix.params.x509certificate.X509CertifiedPublicKey;
import org.xwiki.crypto.pkix.params.x509certificate.extension.ExtendedKeyUsages;
import org.xwiki.crypto.pkix.params.x509certificate.extension.KeyUsage;
import org.xwiki.crypto.pkix.params.x509certificate.extension.X509DnsName;
import org.xwiki.crypto.pkix.params.x509certificate.extension.X509GeneralName;
import org.xwiki.crypto.pkix.params.x509certificate.extension.X509IpAddress;
import org.xwiki.crypto.pkix.params.x509certificate.extension.X509Rfc822Name;
import org.xwiki.crypto.signer.CMSSignedDataGenerator;
import org.xwiki.crypto.signer.CMSSignedDataVerifier;
import org.xwiki.crypto.signer.Signer;
import org.xwiki.crypto.signer.SignerFactory;
import org.xwiki.crypto.signer.param.CMSSignedDataGeneratorParameters;
import org.xwiki.crypto.signer.param.CMSSignedDataVerified;
import org.xwiki.crypto.signer.param.CMSSignerInfo;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="crypto.rsa")
@Singleton
public class RSACryptoScriptService
implements ScriptService {
    public static final String ROLEHINT = "rsa";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    @Inject
    @Named(value="RSA")
    private KeyPairGenerator keyPairGenerator;
    @Inject
    @Named(value="SHA1withRSAEncryption")
    private SignerFactory signerFactory;
    @Inject
    private Provider<X509ExtensionBuilder> extensionBuilder;
    @Inject
    @Named(value="X509")
    private CertificateGeneratorFactory certificateGeneratorFactory;
    @Inject
    private CMSSignedDataGenerator cmsSignedDataGenerator;
    @Inject
    @Named(value="X509")
    private CertificateChainBuilder certificateChainBuilder;
    @Inject
    private CMSSignedDataVerifier cmsSignedDataVerifier;

    public AsymmetricKeyPair generateKeyPair() {
        return this.keyPairGenerator.generate();
    }

    public AsymmetricKeyPair generateKeyPair(int strength) {
        return this.keyPairGenerator.generate((KeyGenerationParameters)new RSAKeyGenerationParameters(strength));
    }

    public AsymmetricKeyPair generateKeyPair(int strength, BigInteger publicExponent, int certainty) {
        return this.keyPairGenerator.generate((KeyGenerationParameters)new RSAKeyGenerationParameters(strength, publicExponent, certainty));
    }

    public CertifiedKeyPair createCertifiedKeyPair(PrivateKeyParameters privateKey, CertifiedPublicKey certificate) {
        return new CertifiedKeyPair(privateKey, certificate);
    }

    public CertifiedKeyPair issueRootCACertificate(AsymmetricKeyPair keyPair, String dn, int validity) throws IOException, GeneralSecurityException {
        return new CertifiedKeyPair(keyPair.getPrivate(), this.certificateGeneratorFactory.getInstance(this.signerFactory.getInstance(true, (CipherParameters)keyPair.getPrivate()), (CertificateGenerationParameters)new X509CertificateGenerationParameters(validity, ((X509ExtensionBuilder)this.extensionBuilder.get()).addBasicConstraints(true).addKeyUsage(true, EnumSet.of(KeyUsage.keyCertSign, KeyUsage.cRLSign)).build())).generate((PrincipalIndentifier)new DistinguishedName((Object)dn), keyPair.getPublic(), (CertificateParameters)new X509CertificateParameters()));
    }

    public CertifiedKeyPair issueIntermediateCertificate(CertifiedKeyPair issuer, AsymmetricKeyPair keyPair, String dn, int validity) throws IOException, GeneralSecurityException {
        return new CertifiedKeyPair(keyPair.getPrivate(), this.issueIntermediateCertificate(issuer, keyPair.getPublic(), dn, validity));
    }

    public CertifiedPublicKey issueIntermediateCertificate(PrivateKeyParameters privateKey, CertifiedPublicKey issuer, PublicKeyParameters publicKey, String dn, int validity) throws IOException, GeneralSecurityException {
        return this.issueIntermediateCertificate(new CertifiedKeyPair(privateKey, issuer), publicKey, dn, validity);
    }

    public CertifiedPublicKey issueIntermediateCertificate(CertifiedKeyPair issuer, PublicKeyParameters publicKey, String dn, int validity) throws IOException, GeneralSecurityException {
        return this.certificateGeneratorFactory.getInstance((Signer)CertifyingSigner.getInstance((boolean)true, (CertifiedKeyPair)issuer, (SignerFactory)this.signerFactory), (CertificateGenerationParameters)new X509CertificateGenerationParameters(validity, ((X509ExtensionBuilder)this.extensionBuilder.get()).addBasicConstraints(0).addKeyUsage(EnumSet.of(KeyUsage.keyCertSign, KeyUsage.cRLSign)).build())).generate((PrincipalIndentifier)new DistinguishedName((Object)dn), publicKey, (CertificateParameters)new X509CertificateParameters());
    }

    public CertifiedKeyPair issueCertificate(CertifiedKeyPair issuer, AsymmetricKeyPair keyPair, String dn, int validity, List<X509GeneralName> subjectAltName) throws IOException, GeneralSecurityException {
        return new CertifiedKeyPair(keyPair.getPrivate(), this.issueCertificate(issuer, keyPair.getPublic(), dn, validity, subjectAltName));
    }

    public CertifiedPublicKey issueCertificate(PrivateKeyParameters privateKey, CertifiedPublicKey issuer, PublicKeyParameters publicKey, String dn, int validity, List<X509GeneralName> subjectAltName) throws IOException, GeneralSecurityException {
        return this.issueCertificate(new CertifiedKeyPair(privateKey, issuer), publicKey, dn, validity, subjectAltName);
    }

    public CertifiedPublicKey issueCertificate(CertifiedKeyPair issuer, PublicKeyParameters publicKey, String dn, int validity, List<X509GeneralName> subjectAltName) throws IOException, GeneralSecurityException {
        X509CertificateParameters params;
        X509ExtensionBuilder builder = ((X509ExtensionBuilder)this.extensionBuilder.get()).addKeyUsage(EnumSet.of(KeyUsage.digitalSignature, KeyUsage.dataEncipherment));
        if (subjectAltName != null) {
            params = new X509CertificateParameters(((X509ExtensionBuilder)this.extensionBuilder.get()).addSubjectAltName(false, subjectAltName.toArray(new X509GeneralName[0])).build());
            HashSet<String> extUsage = new HashSet<String>();
            for (X509GeneralName genName : subjectAltName) {
                if (genName instanceof X509Rfc822Name) {
                    extUsage.add("1.3.6.1.5.5.7.3.4");
                } else if (genName instanceof X509DnsName || genName instanceof X509IpAddress) {
                    extUsage.add("1.3.6.1.5.5.7.3.1");
                    extUsage.add("1.3.6.1.5.5.7.3.2");
                }
                builder.addExtendedKeyUsage(false, new ExtendedKeyUsages(extUsage));
            }
        } else {
            params = new X509CertificateParameters();
        }
        return this.certificateGeneratorFactory.getInstance((Signer)CertifyingSigner.getInstance((boolean)true, (CertifiedKeyPair)issuer, (SignerFactory)this.signerFactory), (CertificateGenerationParameters)new X509CertificateGenerationParameters(validity, builder.build())).generate((PrincipalIndentifier)new DistinguishedName((Object)dn), publicKey, (CertificateParameters)params);
    }

    public byte[] cmsSign(byte[] data, CertifiedKeyPair keyPair, boolean embedContent) throws GeneralSecurityException {
        return this.cmsSign(data, keyPair, null, null, embedContent);
    }

    public byte[] cmsSign(byte[] data, CertifiedKeyPair keyPair, CertificateProvider certificateProvider, boolean embedContent) throws GeneralSecurityException {
        return this.cmsSign(data, keyPair, certificateProvider, null, embedContent);
    }

    public byte[] cmsSign(byte[] data, CertifiedKeyPair keyPair, CertificateProvider certificateProvider, CMSSignedDataVerified existingSignature, boolean embedContent) throws GeneralSecurityException {
        CMSSignedDataGeneratorParameters parameters = new CMSSignedDataGeneratorParameters().addSigner(CertifyingSigner.getInstance((boolean)true, (CertifiedKeyPair)keyPair, (SignerFactory)this.signerFactory));
        if (existingSignature != null) {
            for (CMSSignerInfo existingSigner : existingSignature.getSignatures()) {
                parameters.addSignature(existingSigner);
            }
        }
        HashSet<CertifiedPublicKey> certs = new HashSet<CertifiedPublicKey>();
        if (existingSignature != null && existingSignature.getCertificates() != null) {
            certs.addAll(existingSignature.getCertificates());
        }
        if (certificateProvider != null) {
            if (existingSignature != null) {
                for (CMSSignerInfo existingSigner : existingSignature.getSignatures()) {
                    if (existingSigner.getSubjectKeyIdentifier() != null) {
                        this.addCertificateChain(certificateProvider.getCertificate(existingSigner.getSubjectKeyIdentifier()), certificateProvider, certs);
                        continue;
                    }
                    this.addCertificateChain(certificateProvider.getCertificate(existingSigner.getIssuer(), existingSigner.getSerialNumber()), certificateProvider, certs);
                }
            }
            this.addCertificateChain(keyPair.getCertificate(), certificateProvider, certs);
        }
        if (!certs.isEmpty()) {
            parameters.addCertificates(certs);
        }
        return this.cmsSignedDataGenerator.generate(data, parameters, embedContent);
    }

    private void addCertificateChain(CertifiedPublicKey certificate, CertificateProvider certificateProvider, Collection<CertifiedPublicKey> certs) {
        Collection chain = this.certificateChainBuilder.build(certificate, certificateProvider);
        if (chain != null) {
            certs.addAll(chain);
        }
    }

    public CMSSignedDataVerified cmsVerify(byte[] signature) throws GeneralSecurityException {
        return this.cmsSignedDataVerifier.verify(signature);
    }

    public CMSSignedDataVerified cmsVerify(byte[] signature, byte[] data) throws GeneralSecurityException {
        return this.cmsSignedDataVerifier.verify(signature, data);
    }

    public CMSSignedDataVerified cmsVerify(byte[] signature, CertificateProvider certificateProvider) throws GeneralSecurityException {
        return this.cmsSignedDataVerifier.verify(signature, certificateProvider);
    }

    public CMSSignedDataVerified cmsVerify(byte[] signature, byte[] data, CertificateProvider certificateProvider) throws GeneralSecurityException {
        return this.cmsSignedDataVerifier.verify(signature, data, certificateProvider);
    }

    public boolean checkX509CertificateChainValidity(Collection<CertifiedPublicKey> chain) {
        return this.checkX509CertificateChainValidity(chain, null);
    }

    public boolean checkX509CertificateChainValidity(Collection<CertifiedPublicKey> chain, Date date) {
        if (chain == null || chain.isEmpty()) {
            return false;
        }
        Date checkDate = date != null ? date : new Date();
        boolean rootExpected = true;
        for (CertifiedPublicKey cert : chain) {
            if (!(cert instanceof X509CertifiedPublicKey)) {
                return false;
            }
            if (rootExpected) {
                if (!((X509CertifiedPublicKey)cert).isRootCA()) {
                    return false;
                }
                rootExpected = false;
            }
            if (((X509CertifiedPublicKey)cert).isValidOn(checkDate)) continue;
            return false;
        }
        return true;
    }
}

