/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.script;

import java.io.File;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.script.ScriptingCertificateStore;
import org.xwiki.crypto.script.ScriptingKeyStore;
import org.xwiki.crypto.store.CertificateStore;
import org.xwiki.crypto.store.FileStoreReference;
import org.xwiki.crypto.store.KeyStore;
import org.xwiki.crypto.store.StoreReference;
import org.xwiki.crypto.store.WikiStoreReference;
import org.xwiki.environment.Environment;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authorization.ContextualAuthorizationManager;

@Component
@Named(value="crypto.store")
@Singleton
public class StoreScriptService
implements ScriptService {
    public static final String ROLEHINT = "store";
    @Inject
    private Environment environment;
    @Inject
    @Named(value="X509file")
    private KeyStore x509FileKeyStore;
    @Inject
    @Named(value="X509wiki")
    private KeyStore x509WikiKeyStore;
    @Inject
    @Named(value="X509wiki")
    private CertificateStore x509WikiCertificateStore;
    @Inject
    private ContextualAuthorizationManager contextualAuthorizationManager;

    private StoreReference getFileStoreReference(String filename, boolean multi) {
        File file = !filename.startsWith("/") ? new File(this.environment.getPermanentDirectory(), filename) : new File(filename);
        return new FileStoreReference(file, multi);
    }

    public ScriptingKeyStore getX509FileKeyStore(String filename) {
        return new ScriptingKeyStore(this.x509FileKeyStore, this.getFileStoreReference(filename, true), this.contextualAuthorizationManager);
    }

    public ScriptingKeyStore getX509FileSingleKeyStore(String filename) {
        return new ScriptingKeyStore(this.x509FileKeyStore, this.getFileStoreReference(filename, false), this.contextualAuthorizationManager);
    }

    public ScriptingKeyStore getX509SpaceKeyStore(SpaceReference reference) {
        return new ScriptingKeyStore(this.x509WikiKeyStore, (StoreReference)new WikiStoreReference((EntityReference)reference), this.contextualAuthorizationManager);
    }

    public ScriptingKeyStore getX509DocumentKeyStore(DocumentReference reference) {
        return new ScriptingKeyStore(this.x509WikiKeyStore, (StoreReference)new WikiStoreReference((EntityReference)reference), this.contextualAuthorizationManager);
    }

    public ScriptingCertificateStore getX509SpaceCertificateStore(SpaceReference reference) {
        return new ScriptingCertificateStore(this.x509WikiCertificateStore, (StoreReference)new WikiStoreReference((EntityReference)reference), this.contextualAuthorizationManager);
    }

    public ScriptingCertificateStore getX509DocumentCertificateStore(DocumentReference reference) {
        return new ScriptingCertificateStore(this.x509WikiCertificateStore, (StoreReference)new WikiStoreReference((EntityReference)reference), this.contextualAuthorizationManager);
    }
}

