/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.signer.params;

import org.xwiki.crypto.params.cipher.asymmetric.AsymmetricCipherParameters;
import org.xwiki.crypto.params.cipher.asymmetric.AsymmetricKeyParameters;
import org.xwiki.crypto.signer.params.PssParameters;
import org.xwiki.stability.Unstable;

@Unstable
public class PssSignerParameters
implements AsymmetricCipherParameters {
    private final AsymmetricKeyParameters keyParams;
    private final PssParameters pssParams;

    public PssSignerParameters(AsymmetricKeyParameters keyParams) {
        this.keyParams = keyParams;
        this.pssParams = new PssParameters();
    }

    public PssSignerParameters(AsymmetricKeyParameters keyParams, String hashAlgorithm, int saltLength) {
        this.keyParams = keyParams;
        this.pssParams = new PssParameters(hashAlgorithm, saltLength);
    }

    public PssSignerParameters(AsymmetricKeyParameters keyParams, String hashAlgorithm, String maskGenAlgorithm, int saltLength) {
        this.keyParams = keyParams;
        this.pssParams = new PssParameters(hashAlgorithm, maskGenAlgorithm, saltLength);
    }

    public PssSignerParameters(AsymmetricKeyParameters keyParams, String hashAlgorithm, String maskGenAlgorithm, int saltLength, int trailerField) {
        this.keyParams = keyParams;
        this.pssParams = new PssParameters(hashAlgorithm, maskGenAlgorithm, saltLength, trailerField);
    }

    public AsymmetricKeyParameters getKeyParameters() {
        return this.keyParams;
    }

    public PssParameters getPssParameters() {
        return this.pssParams;
    }
}

