/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.x509.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import org.xwiki.crypto.internal.Convert;
import org.xwiki.crypto.internal.SerializationUtils;
import org.xwiki.crypto.passwd.PasswordCiphertext;
import org.xwiki.crypto.passwd.PasswordCryptoService;
import org.xwiki.crypto.x509.XWikiX509Certificate;
import org.xwiki.crypto.x509.XWikiX509KeyPair;

public class DefaultXWikiX509KeyPair
implements XWikiX509KeyPair {
    private static final long serialVersionUID = 1L;
    private final String privateKeyAlgorithm;
    private final byte[] passwordEncryptedPrivateKey;
    private final byte[] encodedCertificate;
    private transient XWikiX509Certificate certificate;

    public DefaultXWikiX509KeyPair(X509Certificate certificate, PrivateKey key, String password, PasswordCryptoService passwordCryptoService) throws GeneralSecurityException {
        byte[] encodedKey;
        this.privateKeyAlgorithm = key.getAlgorithm();
        this.certificate = new XWikiX509Certificate(certificate);
        this.encodedCertificate = certificate.getEncoded();
        KeyFactory converter = KeyFactory.getInstance(this.privateKeyAlgorithm);
        try {
            encodedKey = converter.getKeySpec(key, PKCS8EncodedKeySpec.class).getEncoded();
        }
        catch (InvalidKeySpecException e) {
            throw new GeneralSecurityException("Failed to encode private key", e);
        }
        this.passwordEncryptedPrivateKey = passwordCryptoService.encryptBytes(encodedKey, password);
    }

    public static XWikiX509KeyPair fromBase64String(String keyPairAsBase64) throws IOException, ClassNotFoundException, CertificateException {
        return DefaultXWikiX509KeyPair.fromBase64String(Convert.fromBase64String(keyPairAsBase64, "-----BEGIN XWIKI CERTIFICATE AND PRIVATE KEY-----\n", "-----END XWIKI CERTIFICATE AND PRIVATE KEY-----"));
    }

    public static XWikiX509KeyPair fromBase64String(byte[] keyPairAsBytes) throws IOException, ClassNotFoundException, CertificateException {
        XWikiX509KeyPair pair = (XWikiX509KeyPair)SerializationUtils.deserialize(keyPairAsBytes);
        try {
            pair.getCertificate();
            return pair;
        }
        catch (RuntimeException e) {
            throw (CertificateException)e.getCause();
        }
    }

    @Override
    public String serializeAsBase64() throws IOException {
        return "-----BEGIN XWIKI CERTIFICATE AND PRIVATE KEY-----\n" + Convert.toChunkedBase64String(this.serialize()) + "-----END XWIKI CERTIFICATE AND PRIVATE KEY-----";
    }

    @Override
    public byte[] serialize() throws IOException {
        return SerializationUtils.serialize(this);
    }

    public int hashCode() {
        return this.encodedCertificate.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DefaultXWikiX509KeyPair) {
            DefaultXWikiX509KeyPair other = (DefaultXWikiX509KeyPair)obj;
            if (!Arrays.equals(this.passwordEncryptedPrivateKey, other.passwordEncryptedPrivateKey)) {
                return false;
            }
            if (!this.privateKeyAlgorithm.equals(other.privateKeyAlgorithm)) {
                return false;
            }
            if (Arrays.equals(this.encodedCertificate, other.encodedCertificate)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("XWikiPrivateCredential\n");
        builder.append("------------\n");
        try {
            builder.append(this.getCertificate().toString());
        }
        catch (RuntimeException e) {
            builder.append("ERROR: Failed to load certificate: " + e.getCause().getMessage());
        }
        builder.append("Private key cannot be shown without a password.");
        return builder.toString();
    }

    @Override
    public XWikiX509Certificate getCertificate() {
        if (this.certificate == null) {
            X509Certificate cert;
            try {
                CertificateFactory converter = CertificateFactory.getInstance("X509");
                cert = (X509Certificate)converter.generateCertificate(new ByteArrayInputStream(this.encodedCertificate));
            }
            catch (CertificateException e) {
                throw new RuntimeException(e);
            }
            this.certificate = new XWikiX509Certificate(cert);
        }
        return this.certificate;
    }

    @Override
    public PublicKey getPublicKey() {
        return this.getCertificate().getPublicKey();
    }

    @Override
    public PrivateKey getPrivateKey(String password) throws GeneralSecurityException {
        PasswordCiphertext ct;
        try {
            ct = (PasswordCiphertext)SerializationUtils.deserialize(this.passwordEncryptedPrivateKey);
        }
        catch (Exception e) {
            throw new GeneralSecurityException("Could not deserialize private key ", e);
        }
        byte[] privateKeyBytes = ct.decrypt(password);
        if (privateKeyBytes == null) {
            throw new GeneralSecurityException("Could not decrypt private key, wrong password or corrupted file.");
        }
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(privateKeyBytes);
        KeyFactory converter = KeyFactory.getInstance(this.privateKeyAlgorithm);
        return converter.generatePrivate(spec);
    }

    @Override
    public String getFingerprint() {
        return this.getCertificate().getFingerprint();
    }
}

