/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.passwd.internal;

import java.io.IOException;
import java.util.Properties;
import org.xwiki.crypto.internal.SerializationUtils;
import org.xwiki.crypto.passwd.MemoryHardKeyDerivationFunction;

public abstract class AbstractMemoryHardKeyDerivationFunction
implements MemoryHardKeyDerivationFunction {
    private static final long serialVersionUID = 1L;
    private final transient int saltSize = 16;
    private final transient int defaultNumberOfKilobytesOfMemoryToUse = 1024;
    private final transient int defaultMillisecondsOfProcessorTime = 200;
    private final transient int defaultDerivedKeyLength = 32;

    @Override
    public byte[] serialize() throws IOException {
        return SerializationUtils.serialize(this);
    }

    @Override
    public void init() {
        this.init(this.getDefaultNumberOfKilobytesOfMemoryToUse(), this.getDefaultMillisecondsOfProcessorTime(), this.getDefaultDerivedKeyLength());
    }

    @Override
    public void init(Properties parameters) {
        int keyLength = this.getDefaultDerivedKeyLength();
        int milliseconds = this.getDefaultMillisecondsOfProcessorTime();
        int kilobytes = this.getDefaultNumberOfKilobytesOfMemoryToUse();
        try {
            String kilobytesString;
            String keyLengthString;
            String millisecondsString = parameters.getProperty("millisecondsOfProcessorTimeToSpend");
            if (millisecondsString != null) {
                milliseconds = Integer.parseInt(millisecondsString);
            }
            if ((keyLengthString = parameters.getProperty("derivedKeyLength")) != null) {
                keyLength = Integer.parseInt(keyLengthString);
            }
            if ((kilobytesString = parameters.getProperty("numberOfKilobytesOfMemoryToUse")) != null) {
                kilobytes = Integer.parseInt(kilobytesString);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse Properties", e);
        }
        this.init(kilobytes, milliseconds, keyLength);
    }

    @Override
    public void init(int millisecondsOfProcessorTimeToSpend, int derivedKeyLength) {
        this.init(this.getDefaultNumberOfKilobytesOfMemoryToUse(), millisecondsOfProcessorTimeToSpend, derivedKeyLength);
    }

    public int getDefaultNumberOfKilobytesOfMemoryToUse() {
        return this.defaultNumberOfKilobytesOfMemoryToUse;
    }

    protected int getDefaultMillisecondsOfProcessorTime() {
        return this.defaultMillisecondsOfProcessorTime;
    }

    protected int getDefaultDerivedKeyLength() {
        return this.defaultDerivedKeyLength;
    }
}

