/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.passwd.internal;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.internal.Convert;
import org.xwiki.crypto.internal.SerializationUtils;
import org.xwiki.crypto.passwd.KeyDerivationFunction;
import org.xwiki.crypto.passwd.PasswordCiphertext;
import org.xwiki.crypto.passwd.PasswordCryptoService;
import org.xwiki.crypto.passwd.PasswordCryptoServiceConfiguration;
import org.xwiki.crypto.passwd.PasswordVerificationFunction;

@Component
@Singleton
public class DefaultPasswordCryptoService
implements PasswordCryptoService {
    private final String ciphertextHeader = "-----BEGIN PASSWORD CIPHERTEXT-----\n";
    private final String ciphertextFooter = "-----END PASSWORD CIPHERTEXT-----";
    @Inject
    private PasswordCryptoServiceConfiguration config;

    @Override
    public synchronized String encryptText(String plaintext, String password) throws GeneralSecurityException {
        byte[] message = Convert.stringToBytes(plaintext);
        return this.ciphertextHeader + Convert.toChunkedBase64String(this.encryptBytes(message, password)) + this.ciphertextFooter;
    }

    @Override
    public synchronized String decryptText(String base64Ciphertext, String password) throws GeneralSecurityException {
        byte[] serial = Convert.fromBase64String(base64Ciphertext, this.ciphertextHeader, this.ciphertextFooter);
        byte[] decrypted = this.decryptBytes(serial, password);
        if (decrypted == null) {
            return null;
        }
        return Convert.bytesToString(decrypted);
    }

    @Override
    public byte[] encryptBytes(byte[] message, String password) throws GeneralSecurityException {
        try {
            KeyDerivationFunction keyFunction = this.config.getKeyDerivationFunctionClassForEncryption().newInstance();
            Properties keyFunctionProps = this.config.getKeyDerivationFunctionPropertiesForEncryption();
            PasswordCiphertext ciphertext = this.config.getCipherClass().newInstance();
            keyFunctionProps.setProperty("derivedKeyLength", Integer.valueOf(ciphertext.getRequiredKeySize()).toString());
            keyFunction.init(keyFunctionProps);
            ciphertext.init(message, password, keyFunction);
            return ciphertext.serialize();
        }
        catch (IOException e) {
            throw new GeneralSecurityException("Failed to serialize ciphertext", e);
        }
        catch (Exception e) {
            throw new GeneralSecurityException("Failed to encrypt text", e);
        }
    }

    @Override
    public byte[] decryptBytes(byte[] rawCiphertext, String password) throws GeneralSecurityException {
        try {
            PasswordCiphertext ciphertext = (PasswordCiphertext)SerializationUtils.deserialize(rawCiphertext);
            return ciphertext.decrypt(password);
        }
        catch (IOException e) {
            throw new GeneralSecurityException("Failed to deserialize ciphertext", e);
        }
        catch (ClassNotFoundException e) {
            throw new GeneralSecurityException("Apparently this ciphertext was encrypted using a cipher which is not available on this installation, was this imported from a newer version?", e);
        }
    }

    @Override
    public String protectPassword(String password) throws GeneralSecurityException {
        try {
            KeyDerivationFunction keyFunction = this.config.getKeyDerivationFunctionClassForPasswordVerification().newInstance();
            Properties keyFunctionProps = this.config.getKeyDerivationFunctionPropertiesForPasswordVerification();
            keyFunction.init(keyFunctionProps);
            PasswordVerificationFunction passwordFunction = this.config.getPasswordVerificationFunctionClass().newInstance();
            passwordFunction.init(keyFunction, Convert.stringToBytes(password));
            return Convert.toBase64String(passwordFunction.serialize());
        }
        catch (Exception e) {
            throw new GeneralSecurityException("Unable to protect password", e);
        }
    }

    @Override
    public boolean isPasswordCorrect(String password, String protectedPassword) throws GeneralSecurityException {
        try {
            byte[] serial = Convert.fromBase64String(protectedPassword);
            PasswordVerificationFunction pvf = (PasswordVerificationFunction)SerializationUtils.deserialize(serial);
            return pvf.isPasswordCorrect(Convert.stringToBytes(password));
        }
        catch (Exception e) {
            throw new GeneralSecurityException("Unable to verify password", e);
        }
    }
}

