/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.display.internal;

import java.util.Arrays;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.display.internal.DocumentContentAsyncRenderer;
import org.xwiki.display.internal.DocumentDisplayer;
import org.xwiki.display.internal.DocumentDisplayerParameters;
import org.xwiki.rendering.async.internal.AsyncRendererConfiguration;
import org.xwiki.rendering.async.internal.block.BlockAsyncRenderer;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererExecutor;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;

@Component
@Named(value="content")
@Singleton
public class DocumentContentDisplayer
implements DocumentDisplayer {
    @Inject
    private Provider<DocumentContentAsyncRenderer> rendererProvider;
    @Inject
    private BlockAsyncRendererExecutor executor;

    @Override
    public XDOM display(DocumentModelBridge document, DocumentDisplayerParameters parameters) {
        DocumentContentAsyncRenderer renderer = (DocumentContentAsyncRenderer)((Object)this.rendererProvider.get());
        Set<String> contextEntries = renderer.initialize(document, parameters);
        AsyncRendererConfiguration configuration = new AsyncRendererConfiguration();
        configuration.setContextEntries(contextEntries);
        try {
            Block block = this.executor.execute((BlockAsyncRenderer)renderer, configuration);
            return block instanceof XDOM ? (XDOM)block : new XDOM(Arrays.asList(block));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

