/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.display.internal;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.display.internal.DocumentDisplayer;
import org.xwiki.display.internal.DocumentDisplayerParameters;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.HeaderBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.block.match.CompositeBlockMatcher;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationManager;
import org.xwiki.velocity.VelocityManager;

@Component
@Named(value="content")
@Singleton
public class DocumentContentDisplayer
implements DocumentDisplayer {
    private static final String IS_IN_RENDERING_ENGINE = "isInRenderingEngine";
    @Inject
    private Logger logger;
    @Inject
    private EntityReferenceSerializer<String> defaultEntityReferenceSerializer;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private Execution execution;
    @Inject
    private VelocityManager velocityManager;
    @Inject
    private TransformationManager transformationManager;
    @Inject
    private ComponentManager componentManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XDOM display(DocumentModelBridge document, DocumentDisplayerParameters parameters) {
        String nameSpace = (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)(parameters.isContentTransformed() && parameters.isTransformationContextIsolated() ? document.getDocumentReference() : this.documentAccessBridge.getCurrentDocumentReference()), new Object[0]);
        Map<Object, Object> xwikiContext = this.getXWikiContextMap();
        Object isInRenderingEngine = xwikiContext.put(IS_IN_RENDERING_ENGINE, true);
        this.maybeOpenNameSpace(nameSpace, parameters.isTransformationContextIsolated(), isInRenderingEngine);
        try {
            XDOM result;
            XDOM xDOM = result = parameters.isExecutionContextIsolated() ? this.displayInIsolatedExecutionContext(document, nameSpace, parameters) : this.display(document, nameSpace, parameters);
            return xDOM;
        }
        finally {
            this.maybeCloseNameSpace(nameSpace, parameters.isTransformationContextIsolated(), isInRenderingEngine);
            if (isInRenderingEngine != null) {
                xwikiContext.put(IS_IN_RENDERING_ENGINE, isInRenderingEngine);
            } else {
                xwikiContext.remove(IS_IN_RENDERING_ENGINE);
            }
        }
    }

    private Map<Object, Object> getXWikiContextMap() {
        return (Map)this.execution.getContext().getProperty("xwikicontext");
    }

    private void maybeOpenNameSpace(String nameSpace, boolean transformationContextIsolated, Object isInRenderingEngine) {
        if (transformationContextIsolated && (isInRenderingEngine == null || isInRenderingEngine == Boolean.FALSE)) {
            try {
                this.velocityManager.getVelocityEngine().startedUsingMacroNamespace(nameSpace);
                this.logger.debug("Started using velocity macro namespace [{}].", (Object)nameSpace);
            }
            catch (Exception e) {
                this.logger.warn("Failed to notify Velocity Macro cache for opening the [{}] namespace. Reason = [{}]", (Object)nameSpace, (Object)e.getMessage());
            }
        }
    }

    private void maybeCloseNameSpace(String nameSpace, boolean transformationContextIsolated, Object isInRenderingEngine) {
        if (transformationContextIsolated && (isInRenderingEngine == null || isInRenderingEngine == Boolean.FALSE)) {
            try {
                this.velocityManager.getVelocityEngine().stoppedUsingMacroNamespace(nameSpace);
                this.logger.debug("Stopped using velocity macro namespace [{}].", (Object)nameSpace);
            }
            catch (Exception e) {
                this.logger.warn("Failed to notify Velocity Macro cache for closing the [{}] namespace. Reason = [{}]", (Object)nameSpace, (Object)e.getMessage());
            }
        }
    }

    private XDOM displayInIsolatedExecutionContext(DocumentModelBridge document, String nameSpace, DocumentDisplayerParameters parameters) {
        HashMap backupObjects = new HashMap();
        try {
            this.documentAccessBridge.pushDocumentInContext(backupObjects, document.getDocumentReference());
            XDOM xDOM = this.display(document, nameSpace, parameters);
            return xDOM;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            this.documentAccessBridge.popDocumentFromContext(backupObjects);
        }
    }

    protected XDOM display(DocumentModelBridge document, String nameSpace, DocumentDisplayerParameters parameters) {
        XDOM content = this.getContent(document, parameters);
        if (!parameters.isContentTransformed()) {
            return content;
        }
        content = content.clone();
        TransformationContext txContext = new TransformationContext(content, document.getSyntax(), parameters.isTransformationContextRestricted());
        txContext.setId(nameSpace);
        try {
            this.transformationManager.performTransformations((Block)content, txContext);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return content;
    }

    private XDOM getContent(DocumentModelBridge document, final DocumentDisplayerParameters parameters) {
        XDOM content;
        XDOM xDOM = content = parameters.isContentTranslated() ? this.getTranslatedContent(document) : document.getXDOM();
        if (parameters.getSectionId() != null) {
            HeaderBlock headerBlock = (HeaderBlock)content.getFirstBlock((BlockMatcher)new CompositeBlockMatcher(new BlockMatcher[]{new ClassBlockMatcher(HeaderBlock.class), new BlockMatcher(){

                public boolean match(Block block) {
                    return ((HeaderBlock)block).getId().equals(parameters.getSectionId());
                }
            }}), Block.Axes.DESCENDANT);
            if (headerBlock == null) {
                throw new RuntimeException("Cannot find section [" + parameters.getSectionId() + "] in document [" + (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)document.getDocumentReference(), new Object[0]) + "]");
            }
            content = new XDOM(headerBlock.getSection().getChildren(), content.getMetaData());
        }
        return content;
    }

    private XDOM getTranslatedContent(DocumentModelBridge document) {
        try {
            DocumentModelBridge translatedDocument = this.documentAccessBridge.getDocument(document.getDocumentReference());
            if (!document.getRealLanguage().equals(translatedDocument.getRealLanguage())) {
                if (document.getSyntax().equals((Object)translatedDocument.getSyntax())) {
                    return translatedDocument.getXDOM();
                }
                return this.parseContent(translatedDocument.getContent(), document.getSyntax().toIdString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return document.getXDOM();
    }

    private XDOM parseContent(String content, String syntaxId) {
        try {
            Parser parser = (Parser)this.componentManager.getInstance(Parser.class, syntaxId);
            return parser.parse((Reader)new StringReader(content));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Execution getExecution() {
        return this.execution;
    }
}

