/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.display.internal;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.display.internal.AbstractDocumentTitleDisplayer;
import org.xwiki.display.internal.DisplayConfiguration;
import org.xwiki.display.internal.DocumentDisplayerParameters;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.HeaderBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationException;
import org.xwiki.rendering.transformation.TransformationManager;

@Component
@Named(value="title")
@Singleton
public class DocumentTitleDisplayer
extends AbstractDocumentTitleDisplayer {
    @Inject
    private TransformationManager transformationManager;
    @Inject
    private DisplayConfiguration displayConfiguration;

    @Override
    protected XDOM extractTitleFromContent(DocumentModelBridge document, DocumentDisplayerParameters parameters) {
        HeaderBlock heading;
        List blocks = document.getXDOM().getBlocks((BlockMatcher)new ClassBlockMatcher(HeaderBlock.class), Block.Axes.DESCENDANT);
        if (!blocks.isEmpty() && (heading = (HeaderBlock)blocks.get(0)).getLevel().getAsInt() <= this.displayConfiguration.getTitleHeadingDepth()) {
            XDOM headingXDOM = new XDOM(Collections.singletonList(heading));
            try {
                Block headingBlock;
                TransformationContext txContext = new TransformationContext(headingXDOM, document.getSyntax(), parameters.isTransformationContextRestricted());
                txContext.setTargetSyntax(parameters.getTargetSyntax());
                this.transformationManager.performTransformations((Block)headingXDOM, txContext);
                Block block = headingBlock = headingXDOM.getChildren().size() > 0 ? (Block)headingXDOM.getChildren().get(0) : null;
                if (headingBlock instanceof HeaderBlock) {
                    return new XDOM(headingBlock.getChildren());
                }
            }
            catch (TransformationException e) {
                this.getLogger().warn("Failed to extract title from document content.");
            }
        }
        return null;
    }
}

