/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.edit.script;

import java.lang.reflect.Type;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.edit.EditConfiguration;
import org.xwiki.edit.Editor;
import org.xwiki.edit.EditorManager;
import org.xwiki.script.service.ScriptService;
import org.xwiki.script.service.ScriptServiceManager;

@Component
@Singleton
@Named(value="edit")
public class EditScriptService
implements ScriptService {
    public static final String ROLE_HINT = "edit";
    @Inject
    private EditorManager editorManager;
    @Inject
    private EditConfiguration editConfig;
    @Inject
    private ScriptServiceManager scriptServiceManager;

    public <D> List<Editor<D>> getEditors(Type dataType) {
        return this.editorManager.getEditors(dataType);
    }

    public <D> List<Editor<D>> getEditors(Type dataType, String category) {
        return this.editorManager.getEditors(dataType, category);
    }

    public <D> Editor<D> getEditor(Type dataType, String hint) {
        return this.editorManager.getEditor(dataType, hint);
    }

    public <D> Editor<D> getDefaultEditor(Type dataType) {
        return this.editorManager.getDefaultEditor(dataType);
    }

    public <D> Editor<D> getDefaultEditor(Type dataType, String category) {
        return this.editorManager.getDefaultEditor(dataType, category);
    }

    public String getDefaultEditorId(Type dataType) {
        return this.editConfig.getDefaultEditor(dataType);
    }

    public String getDefaultEditorId(Type dataType, String category) {
        return this.editConfig.getDefaultEditor(dataType, category);
    }

    public <S extends ScriptService> S get(String serviceName) {
        return (S)this.scriptServiceManager.get("edit." + serviceName);
    }
}

