/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.edit;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.script.ScriptContext;
import org.xwiki.edit.EditException;
import org.xwiki.edit.Editor;
import org.xwiki.script.ScriptContextManager;
import org.xwiki.stability.Unstable;

@Unstable
public abstract class AbstractEditor<D>
implements Editor<D> {
    private static final String EDIT_CONTEXT_KEY = "edit";
    @Inject
    private ScriptContextManager scripts;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String render(D data, Map<String, Object> parameters) throws EditException {
        ScriptContext scriptContext = this.scripts.getCurrentScriptContext();
        Object currentEdit = scriptContext.getAttribute(EDIT_CONTEXT_KEY, 100);
        try {
            scriptContext.setAttribute(EDIT_CONTEXT_KEY, this.getEditContext(data, parameters), 100);
            String string = this.render();
            return string;
        }
        finally {
            scriptContext.setAttribute(EDIT_CONTEXT_KEY, currentEdit, 100);
        }
    }

    protected Map<String, Object> getEditContext(D data, Map<String, Object> parameters) {
        HashMap<String, Object> editContext = new HashMap<String, Object>();
        editContext.put("data", data);
        editContext.put("parameters", parameters);
        return editContext;
    }

    protected abstract String render() throws EditException;
}

