/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream;

import javax.inject.Inject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.manager.NamespacedComponentManager;
import org.xwiki.component.namespace.NamespaceContextExecutor;
import org.xwiki.component.namespace.NamespaceUtils;
import org.xwiki.eventstream.RecordableEventDescriptor;
import org.xwiki.localization.ContextualLocalizationManager;

public abstract class AbstractRecordableEventDescriptor
implements RecordableEventDescriptor {
    @Inject
    protected Logger logger;
    @Inject
    protected ComponentManager componentManager;
    @Inject
    protected ContextualLocalizationManager contextualLocalizationManager;
    @Inject
    protected NamespaceContextExecutor namespaceContextExecutor;
    protected String descriptionTranslationKey;
    protected String applicationTranslationKey;

    public AbstractRecordableEventDescriptor(String descriptionTranslationKey, String applicationTranslationKey) {
        this.descriptionTranslationKey = descriptionTranslationKey;
        this.applicationTranslationKey = applicationTranslationKey;
    }

    protected String getLocalizedMessage(String key) {
        NamespacedComponentManager namespacedComponentManager;
        String namespaceOfTheDescriptor;
        if (this.componentManager instanceof NamespacedComponentManager && (namespaceOfTheDescriptor = (namespacedComponentManager = (NamespacedComponentManager)this.componentManager).getNamespace()) != null) {
            try {
                return (String)this.namespaceContextExecutor.execute(NamespaceUtils.toNamespace((String)namespaceOfTheDescriptor), () -> this.contextualLocalizationManager.getTranslationPlain(key, new Object[0]));
            }
            catch (Exception e) {
                this.logger.warn("Failed to render the translation key [{}] in the namespace [{}] for the event descriptor of [{}].", new Object[]{key, namespaceOfTheDescriptor, this.getEventType(), e});
            }
        }
        return this.contextualLocalizationManager.getTranslationPlain(key, new Object[0]);
    }

    @Override
    public String getDescription() {
        return this.getLocalizedMessage(this.descriptionTranslationKey);
    }

    @Override
    public String getApplicationName() {
        return this.getLocalizedMessage(this.applicationTranslationKey);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getApplicationId()).append((Object)this.getEventType()).toHashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RecordableEventDescriptor) {
            RecordableEventDescriptor other = (RecordableEventDescriptor)o;
            EqualsBuilder equalsBuilder = new EqualsBuilder();
            equalsBuilder.append((Object)other.getApplicationId(), (Object)this.getApplicationId());
            equalsBuilder.append((Object)other.getEventType(), (Object)this.getEventType());
            return equalsBuilder.isEquals();
        }
        return false;
    }
}

