/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.script;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.eventstream.EventStore;
import org.xwiki.eventstream.EventStream;
import org.xwiki.eventstream.EventStreamException;
import org.xwiki.eventstream.RecordableEventDescriptor;
import org.xwiki.eventstream.RecordableEventDescriptorManager;
import org.xwiki.eventstream.internal.LegacyEventMigrationRequest;
import org.xwiki.eventstream.query.SimpleEventQuery;
import org.xwiki.job.Job;
import org.xwiki.job.JobException;
import org.xwiki.job.JobExecutor;
import org.xwiki.job.JobStatusStore;
import org.xwiki.job.Request;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.query.QueryException;
import org.xwiki.script.service.ScriptService;
import org.xwiki.stability.Unstable;

@Component
@Singleton
@Named(value="eventstream")
public class EventStreamScriptService
implements ScriptService {
    private static final List<String> LEGACY_MIGRATOR_ID = Arrays.asList("event", "legacy", "migrator");
    @Inject
    private RecordableEventDescriptorManager recordableEventDescriptorManager;
    @Inject
    private JobExecutor jobs;
    @Inject
    private JobStatusStore statuses;
    @Inject
    private EventStore eventStore;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;
    private EventStream eventStream;

    public List<RecordableEventDescriptor> getRecordableEventDescriptors(boolean allWikis) throws EventStreamException {
        return this.recordableEventDescriptorManager.getRecordableEventDescriptors(allWikis);
    }

    public RecordableEventDescriptor getDescriptorForEventType(String eventType, boolean allWikis) throws EventStreamException {
        return this.recordableEventDescriptorManager.getDescriptorForEventType(eventType, allWikis);
    }

    @Unstable
    public JobStatus getLegacyMigrationStatus() {
        Job job = this.jobs.getJob(LEGACY_MIGRATOR_ID);
        if (job != null) {
            return job.getStatus();
        }
        return this.statuses.getJobStatus(LEGACY_MIGRATOR_ID);
    }

    @Unstable
    public JobStatus startLegacyMigration(Date since) throws JobException {
        return this.jobs.execute("eventstream.legacycopy", (Request)new LegacyEventMigrationRequest(since, LEGACY_MIGRATOR_ID)).getStatus();
    }

    private EventStream getEventStream() {
        if (this.eventStream == null && this.componentManager.hasComponent(EventStream.class)) {
            try {
                this.eventStream = (EventStream)this.componentManager.getInstance(EventStream.class);
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to lookup EventStream legacy component", (Throwable)e);
            }
        }
        return this.eventStream;
    }

    public long getLegacyEventCount() throws QueryException {
        return this.getEventStream() != null ? this.eventStream.countEvents() : 0L;
    }

    public long getEventCount() throws EventStreamException {
        return this.eventStore.search(new SimpleEventQuery(0L, 0L)).getTotalHits();
    }
}

