/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.RecordableEvent;
import org.xwiki.eventstream.RecordableEventConverter;
import org.xwiki.eventstream.TargetableEvent;
import org.xwiki.eventstream.internal.DefaultEvent;

@Component
@Singleton
public class DefaultRecordableEventConverter
implements RecordableEventConverter {
    @Inject
    private Provider<XWikiContext> contextProvider;

    public Event convert(RecordableEvent recordableEvent, String source, Object data) throws Exception {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        DefaultEvent convertedEvent = new DefaultEvent();
        convertedEvent.setType(recordableEvent.getClass().getCanonicalName());
        convertedEvent.setApplication(source);
        convertedEvent.setDate(new Date());
        convertedEvent.setUser(context.getUserReference());
        convertedEvent.setWiki(context.getWikiReference());
        if (recordableEvent instanceof TargetableEvent) {
            convertedEvent.setTarget(((TargetableEvent)recordableEvent).getTarget());
        }
        if (data instanceof String) {
            convertedEvent.setBody((String)data);
        } else if (data instanceof XWikiDocument) {
            XWikiDocument document = (XWikiDocument)data;
            convertedEvent.setDocument(document.getDocumentReference());
            convertedEvent.setDocumentVersion(document.getVersion());
            convertedEvent.setDocumentTitle(document.getRenderedTitle(context));
        }
        return convertedEvent;
    }

    public List<RecordableEvent> getSupportedEvents() {
        return Collections.emptyList();
    }
}

