/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.internal;

import com.xpn.xwiki.objects.BaseObject;
import java.lang.reflect.Type;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.namespace.Namespace;
import org.xwiki.component.namespace.NamespaceContextExecutor;
import org.xwiki.component.wiki.WikiComponent;
import org.xwiki.component.wiki.WikiComponentScope;
import org.xwiki.eventstream.EventStreamException;
import org.xwiki.eventstream.UntypedRecordableEventDescriptor;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.model.EntityType;
import org.xwiki.model.namespace.WikiNamespace;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.text.StringUtils;

public class DefaultUntypedRecordableEventDescriptor
implements UntypedRecordableEventDescriptor,
WikiComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultUntypedRecordableEventDescriptor.class);
    private static final String UNTYPED_EVENT_EVENT_TYPE = "eventType";
    private static final String UNTYPED_EVENT_DESCRIPTOR_DESCRIPTION = "eventDescription";
    private static final String UNTYPED_EVENT_DESCRIPTOR_VALIDATION_EXPRESSION = "validationExpression";
    private static final String UNTYPED_EVENT_DESCRIPTOR_TARGET = "target";
    private static final String UNTYPED_EVENT_DESCRIPTOR_EVENT_TRIGGERS = "listenTo";
    private static final String UNTYPED_EVENT_DESCRIPTOR_OBJECT_TYPE = "objectType";
    private static final String UNTYPED_EVENT_DESCRIPTOR_APPLICATION_NAME = "applicationName";
    private static final String UNTYPED_EVENT_DESCRIPTOR_APPLICATION_ID = "applicationId";
    private static final String UNTYPED_EVENT_DESCRIPTOR_APPLICATION_ICON = "applicationIcon";
    private static final String UNTYPED_EVENT_DESCRIPTOR_EVENT_TYPE_ICON = "eventTypeIcon";
    private String eventType;
    private String validationExpression;
    private String target;
    private List<String> objectTypes;
    private String eventDescription;
    private String applicationName;
    private String applicationId;
    private String applicationIcon;
    private String eventTypeIcon;
    private List<String> eventTriggers;
    private EntityReference entityReference;
    private DocumentReference authorReference;
    private ContextualLocalizationManager contextualLocalizationManager;
    private NamespaceContextExecutor namespaceContextExecutor;

    public DefaultUntypedRecordableEventDescriptor(EntityReference reference, DocumentReference authorReference, BaseObject baseObject, ContextualLocalizationManager contextualLocalizationManager, NamespaceContextExecutor namespaceContextExecutor) throws EventStreamException {
        this.entityReference = reference;
        this.authorReference = authorReference;
        this.setProperties(baseObject);
        this.contextualLocalizationManager = contextualLocalizationManager;
        this.namespaceContextExecutor = namespaceContextExecutor;
    }

    private void setProperties(BaseObject untypedEventObject) throws EventStreamException {
        try {
            this.eventType = untypedEventObject.getStringValue(UNTYPED_EVENT_EVENT_TYPE);
            this.validationExpression = untypedEventObject.getStringValue(UNTYPED_EVENT_DESCRIPTOR_VALIDATION_EXPRESSION);
            this.target = untypedEventObject.getStringValue(UNTYPED_EVENT_DESCRIPTOR_TARGET);
            this.objectTypes = untypedEventObject.getListValue(UNTYPED_EVENT_DESCRIPTOR_OBJECT_TYPE);
            this.eventDescription = untypedEventObject.getStringValue(UNTYPED_EVENT_DESCRIPTOR_DESCRIPTION);
            this.eventTriggers = untypedEventObject.getListValue(UNTYPED_EVENT_DESCRIPTOR_EVENT_TRIGGERS);
            this.applicationName = untypedEventObject.getStringValue(UNTYPED_EVENT_DESCRIPTOR_APPLICATION_NAME);
            String rawApplicationIdProperty = untypedEventObject.getStringValue(UNTYPED_EVENT_DESCRIPTOR_APPLICATION_ID);
            this.applicationId = rawApplicationIdProperty != null && StringUtils.isNotBlank((CharSequence)rawApplicationIdProperty) ? rawApplicationIdProperty : this.applicationName;
            this.applicationIcon = untypedEventObject.getStringValue(UNTYPED_EVENT_DESCRIPTOR_APPLICATION_ICON);
            this.eventTypeIcon = untypedEventObject.getStringValue(UNTYPED_EVENT_DESCRIPTOR_EVENT_TYPE_ICON);
        }
        catch (Exception e) {
            throw new EventStreamException(String.format("Unable to extract the parameters of the [%s] EventClass.", untypedEventObject), (Throwable)e);
        }
    }

    public String getValidationExpression() {
        return this.validationExpression;
    }

    public List<String> getEventTriggers() {
        return this.eventTriggers;
    }

    public List<String> getObjectTypes() {
        return this.objectTypes;
    }

    public EntityReference getEntityReference() {
        return this.entityReference;
    }

    public DocumentReference getDocumentReference() {
        return (DocumentReference)this.entityReference.getParent();
    }

    public DocumentReference getAuthorReference() {
        return this.authorReference;
    }

    public Type getRoleType() {
        return UntypedRecordableEventDescriptor.class;
    }

    public String getRoleHint() {
        return this.eventType;
    }

    public WikiComponentScope getScope() {
        return WikiComponentScope.WIKI;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getApplicationName() {
        return this.getLocalizedMessage(this.applicationName);
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getDescription() {
        return this.getLocalizedMessage(this.eventDescription);
    }

    public String getApplicationIcon() {
        return this.applicationIcon;
    }

    public String getEventTypeIcon() {
        return this.eventTypeIcon;
    }

    public String getTargetExpression() {
        return this.target;
    }

    protected String getLocalizedMessage(String key) {
        String wikiWhereTheDescriptorIs = this.entityReference.extractReference(EntityType.WIKI).getName();
        WikiNamespace namespaceOfTheDescriptor = new WikiNamespace(wikiWhereTheDescriptorIs);
        try {
            return (String)this.namespaceContextExecutor.execute((Namespace)namespaceOfTheDescriptor, () -> this.contextualLocalizationManager.getTranslationPlain(key, new Object[0]));
        }
        catch (Exception e) {
            LOGGER.warn("Failed to render the translation key [{}] in the namespace [{}] for the event descriptor of [{}].", new Object[]{key, namespaceOfTheDescriptor, this.getEventType(), e});
            return this.contextualLocalizationManager.getTranslationPlain(key, new Object[0]);
        }
    }
}

