/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.internal.observation;

import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventStream;
import org.xwiki.eventstream.events.AbstractEventStreamEvent;
import org.xwiki.observation.remote.LocalEventData;
import org.xwiki.observation.remote.RemoteEventData;
import org.xwiki.observation.remote.converter.AbstractEventConverter;
import org.xwiki.query.QueryException;

@Component
@Singleton
@Named(value="eventstreamevent")
public class EventStreamEventConverter
extends AbstractEventConverter {
    @Inject
    private EventStream stream;
    @Inject
    private Logger logger;

    public boolean toRemote(LocalEventData localEvent, RemoteEventData remoteEvent) {
        if (localEvent.getEvent() instanceof AbstractEventStreamEvent) {
            remoteEvent.setEvent((Serializable)localEvent.getEvent());
            remoteEvent.setSource(this.serializeEvent((Event)localEvent.getSource()));
            return true;
        }
        return false;
    }

    private Serializable serializeEvent(Event local) {
        if (local != null) {
            return local.getId();
        }
        return null;
    }

    public boolean fromRemote(RemoteEventData remoteEvent, LocalEventData localEvent) {
        if (remoteEvent.getEvent() instanceof AbstractEventStreamEvent) {
            try {
                localEvent.setEvent((org.xwiki.observation.event.Event)remoteEvent.getEvent());
                localEvent.setSource((Object)this.unserializeEvent(remoteEvent.getSource()));
                return true;
            }
            catch (Exception e) {
                this.logger.error("Failed to convert remote event [{}]", (Object)remoteEvent, (Object)e);
            }
        }
        return false;
    }

    private Event unserializeEvent(Serializable remote) throws QueryException {
        if (remote instanceof String) {
            return this.stream.getEvent((String)((Object)remote));
        }
        return null;
    }
}

