/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.internal;

import java.util.ArrayList;
import java.util.List;
import org.xwiki.extension.job.JobProgress;
import org.xwiki.extension.job.JobStatus;
import org.xwiki.extension.job.Request;
import org.xwiki.extension.job.internal.DefaultJobProgress;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.LogQueue;
import org.xwiki.logging.LoggerManager;
import org.xwiki.logging.event.LogEvent;
import org.xwiki.logging.event.LogQueueListener;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;

public class DefaultJobStatus<R extends Request>
implements JobStatus {
    private ObservationManager observationManager;
    private LoggerManager loggerManager;
    private String id;
    private JobStatus.State state;
    private R request;
    private LogQueue logs = new LogQueue();
    private DefaultJobProgress progress;

    public DefaultJobStatus(R request, String id, ObservationManager observationManager, LoggerManager loggerManager) {
        this.request = request;
        this.observationManager = observationManager;
        this.loggerManager = loggerManager;
        this.id = id;
        this.progress = new DefaultJobProgress(this.id);
    }

    void startListening() {
        this.observationManager.addListener((EventListener)this.progress);
        this.loggerManager.pushLogListener((EventListener)new LogQueueListener(LogQueueListener.class.getName() + '_' + this.id, this.logs));
    }

    void stopListening() {
        this.loggerManager.popLogListener();
        this.observationManager.removeListener(this.progress.getName());
    }

    @Override
    public JobStatus.State getState() {
        return this.state;
    }

    public void setState(JobStatus.State state) {
        this.state = state;
    }

    public R getRequest() {
        return this.request;
    }

    @Override
    public LogQueue getLog() {
        return this.logs;
    }

    @Override
    public List<LogEvent> getLog(LogLevel level) {
        ArrayList<LogEvent> levelLogs = new ArrayList<LogEvent>();
        for (LogEvent log : this.logs) {
            if (log.getLevel() != level) continue;
            levelLogs.add(log);
        }
        return levelLogs;
    }

    @Override
    public JobProgress getProgress() {
        return this.progress;
    }
}

