/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.xwiki.extension.AbstractExtension;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionException;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.repository.internal.DefaultLocalExtensionRepository;

public class DefaultLocalExtension
extends AbstractExtension
implements LocalExtension {
    private Set<String> namespaces;

    public DefaultLocalExtension(DefaultLocalExtensionRepository repository, ExtensionId id, String type) {
        super(repository, id, type);
    }

    public DefaultLocalExtension(DefaultLocalExtensionRepository repository, Extension extension) {
        super(repository, extension);
    }

    @Override
    public void download(File file) throws ExtensionException {
        FileInputStream sourceStream = null;
        FileOutputStream targetStream = null;
        try {
            sourceStream = new FileInputStream(this.getFile());
            targetStream = new FileOutputStream(file);
            IOUtils.copy((InputStream)sourceStream, (OutputStream)targetStream);
        }
        catch (Exception e) {
            throw new ExtensionException("Failed to copy file", e);
        }
        finally {
            IOException closeException = null;
            if (sourceStream != null) {
                try {
                    ((InputStream)sourceStream).close();
                }
                catch (IOException e) {
                    closeException = e;
                }
            }
            if (targetStream != null) {
                try {
                    ((OutputStream)targetStream).close();
                }
                catch (IOException e) {
                    closeException = e;
                }
            }
            if (closeException != null) {
                throw new ExtensionException("Failed to close file", closeException);
            }
        }
    }

    @Override
    public Collection<String> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Collection<String> namespaces) {
        this.namespaces = namespaces != null ? new HashSet<String>(namespaces) : null;
    }

    public void addNamespace(String namespace) {
        if (this.namespaces == null) {
            this.namespaces = new HashSet<String>();
        }
        this.namespaces.add(namespace);
    }

    @Override
    public File getFile() {
        return this.getProperty("local.file", null);
    }

    public void setFile(File file) {
        this.putProperty("local.file", file);
    }

    @Override
    public boolean isInstalled() {
        return this.getProperty("local.installed", false);
    }

    @Override
    public boolean isInstalled(String namespace) {
        return this.isInstalled() && (this.namespaces == null || this.namespaces.contains(namespace));
    }

    public void setInstalled(boolean installed) {
        this.putProperty("local.installed", installed);
    }

    public void setInstalled(boolean installed, String namespace) {
        if (namespace == null) {
            this.setInstalled(installed);
            this.setNamespaces(null);
        } else if (installed) {
            this.setInstalled(true);
            this.addNamespace(namespace);
        } else if (this.namespaces != null) {
            this.namespaces.remove(namespace);
            if (this.namespaces.isEmpty()) {
                this.setInstalled(false);
                this.namespaces = null;
            }
        }
    }

    @Override
    public boolean isDependency() {
        return this.getProperty("local.dependency", false);
    }

    public void setDependency(boolean dependency) {
        this.putProperty("local.dependency", dependency);
    }
}

