/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.container.Container;
import org.xwiki.extension.ExtensionManagerConfiguration;
import org.xwiki.extension.internal.ExtensionManagerConfigurationException;
import org.xwiki.extension.repository.ExtensionRepositoryId;

@Component
@Singleton
public class DefaultExtensionManagerConfiguration
implements ExtensionManagerConfiguration {
    private static final Pattern REPOSITORYIDPATTERN = Pattern.compile("([^:]+):([^:]+):(.+)");
    private static final String TYPE_MAVEN = "maven";
    @Inject
    @Named(value="xwikiproperties")
    private ConfigurationSource configurationSource;
    @Inject
    private Logger logger;
    @Inject
    private Container container;
    private File localRepository;

    public File getHome() {
        return new File(this.container.getApplicationContext().getPermanentDirectory(), "extension/");
    }

    @Override
    public File getLocalRepository() {
        if (this.localRepository == null) {
            String localRepositoryPath = (String)this.configurationSource.getProperty("extension.localRepository");
            this.localRepository = localRepositoryPath == null ? new File(this.getHome(), "repository/") : new File(localRepositoryPath);
        }
        return this.localRepository;
    }

    @Override
    public List<ExtensionRepositoryId> getRepositories() {
        ArrayList<ExtensionRepositoryId> repositories = new ArrayList<ExtensionRepositoryId>();
        List repositoryStrings = (List)this.configurationSource.getProperty("extension.repositories", Collections.emptyList());
        if (repositoryStrings != null && !repositoryStrings.isEmpty()) {
            for (String repositoryString : repositoryStrings) {
                try {
                    ExtensionRepositoryId extensionRepositoryId = this.parseRepository(repositoryString);
                    repositories.add(extensionRepositoryId);
                }
                catch (Exception e) {
                    this.logger.warn("Faild to parse repository [" + repositoryString + "] from configuration", (Throwable)e);
                }
            }
        } else {
            try {
                repositories.add(new ExtensionRepositoryId("maven-xwiki", TYPE_MAVEN, new URI("http://nexus.xwiki.org/nexus/content/groups/public")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return repositories;
    }

    private ExtensionRepositoryId parseRepository(String repositoryString) throws URISyntaxException, ExtensionManagerConfigurationException {
        Matcher matcher = REPOSITORYIDPATTERN.matcher(repositoryString);
        if (matcher.matches()) {
            return new ExtensionRepositoryId(matcher.group(1), matcher.group(2), new URI(matcher.group(3)));
        }
        throw new ExtensionManagerConfigurationException("Don't match repository configuration [" + repositoryString + "]");
    }
}

