/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.internal;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.job.Job;
import org.xwiki.extension.job.JobException;
import org.xwiki.extension.job.JobManager;
import org.xwiki.extension.job.JobStatus;
import org.xwiki.extension.job.Request;
import org.xwiki.extension.job.UninstallRequest;

@Component
@Singleton
public class DefaultJobManager
implements JobManager {
    @Inject
    private ComponentManager componentManager;
    private Job currentJob;

    @Override
    public Job getCurrentJob() {
        return this.currentJob;
    }

    @Override
    public Job install(InstallRequest request) throws JobException {
        return this.executeJob("install", request);
    }

    @Override
    public Job uninstall(UninstallRequest request) throws JobException {
        return this.executeJob("uninstall", request);
    }

    @Override
    public synchronized Job executeJob(String taskId, Request request) throws JobException {
        if (this.currentJob != null && this.currentJob.getStatus().getState() != JobStatus.State.FINISHED) {
            throw new JobException("A task is already running");
        }
        try {
            this.currentJob = (Job)this.componentManager.lookup(Job.class, taskId);
        }
        catch (ComponentLookupException e) {
            throw new JobException("Failed to lookup any Task for role hint [" + taskId + "]", e);
        }
        this.currentJob.start(request);
        return this.currentJob;
    }
}

