/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.internal;

import java.text.MessageFormat;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.event.ExtensionInstalledEvent;
import org.xwiki.extension.event.ExtensionUpgradedEvent;
import org.xwiki.extension.handler.ExtensionHandlerManager;
import org.xwiki.extension.internal.VersionManager;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.job.internal.AbstractJob;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepositoryException;
import org.xwiki.observation.event.Event;

@Component
@Named(value="install")
public class InstallJob
extends AbstractJob<InstallRequest> {
    @Inject
    private ExtensionRepositoryManager repositoryManager;
    @Inject
    private CoreExtensionRepository coreExtensionRepository;
    @Inject
    private LocalExtensionRepository localExtensionRepository;
    @Inject
    private VersionManager versionManager;
    @Inject
    private ExtensionHandlerManager extensionHandlerManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void start() throws Exception {
        List<ExtensionId> extensions = ((InstallRequest)this.getRequest()).getExtensions();
        this.notifyPushLevelProgress(extensions.size());
        try {
            for (ExtensionId extensionId : extensions) {
                if (((InstallRequest)this.getRequest()).hasNamespaces()) {
                    List<String> namespaces = ((InstallRequest)this.getRequest()).getNamespaces();
                    this.notifyPushLevelProgress(namespaces.size());
                    try {
                        for (String namespace : namespaces) {
                            this.installExtension(extensionId, namespace);
                            this.notifyStepPropress();
                        }
                    }
                    finally {
                        this.notifyPopLevelProgress();
                    }
                } else {
                    this.installExtension(extensionId, null);
                }
                this.notifyStepPropress();
            }
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }

    public LocalExtension installExtension(ExtensionId extensionId, String namespace) throws InstallException {
        return this.installExtension(extensionId, false, namespace);
    }

    private LocalExtension installExtension(ExtensionId extensionId, boolean dependency, String namespace) throws InstallException {
        if (this.coreExtensionRepository.exists(extensionId.getId())) {
            throw new InstallException(MessageFormat.format("[{0}]: core extension", extensionId.getId()));
        }
        if (namespace != null) {
            this.logger.info("Installing extension [{}] on namespace [{}]", (Object)extensionId, (Object)namespace);
        } else {
            this.logger.info("Installing extension [{}]", (Object)extensionId);
        }
        LocalExtension previousExtension = null;
        LocalExtension localExtension = this.localExtensionRepository.getInstalledExtension(extensionId.getId(), namespace);
        if (localExtension != null) {
            int diff = this.versionManager.compareVersions(extensionId.getVersion(), localExtension.getId().getVersion());
            if (diff == 0) {
                throw new InstallException(MessageFormat.format("[{0}]: already installed", extensionId.getId()));
            }
            if (diff < 0) {
                throw new InstallException(MessageFormat.format("[{0}]: a more recent version is already installed", extensionId.getId()));
            }
            previousExtension = localExtension;
        }
        LocalExtension installedExtension = this.installExtension(previousExtension, extensionId, dependency, namespace);
        return installedExtension;
    }

    private LocalExtension installExtensionDependency(ExtensionDependency extensionDependency, String namespace) throws InstallException {
        if (this.coreExtensionRepository.exists(extensionDependency.getId())) {
            return null;
        }
        if (namespace != null) {
            this.logger.info("Installing extension dependency [{}] on namespace [{}]", (Object)extensionDependency, (Object)namespace);
        } else {
            this.logger.info("Installing extension dependency [{}]", (Object)extensionDependency);
        }
        LocalExtension previousExtension = null;
        LocalExtension localExtension = this.localExtensionRepository.getInstalledExtension(extensionDependency.getId(), namespace);
        if (localExtension != null) {
            int diff = this.versionManager.compareVersions(extensionDependency.getVersion(), localExtension.getId().getVersion());
            if (diff > 0) {
                previousExtension = localExtension;
            } else {
                return null;
            }
        }
        return this.installExtension(previousExtension, new ExtensionId(extensionDependency.getId(), extensionDependency.getVersion()), true, namespace);
    }

    private LocalExtension installExtension(LocalExtension previousExtension, ExtensionId extensionId, boolean dependency, String namespace) throws InstallException {
        this.notifyPushLevelProgress(2);
        try {
            Extension extension = this.resolveExtension(extensionId);
            this.notifyStepPropress();
            try {
                LocalExtension localExtension = this.installExtension(previousExtension, extension, dependency, namespace);
                return localExtension;
            }
            catch (Exception e) {
                throw new InstallException("Failed to install extension", e);
            }
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }

    private Extension resolveExtension(ExtensionId extensionId) throws InstallException {
        Extension extension;
        try {
            extension = this.localExtensionRepository.resolve(extensionId);
        }
        catch (ResolveException e) {
            this.logger.debug("Can't find extension in local repository, trying to download it.", (Throwable)e);
            try {
                extension = this.repositoryManager.resolve(extensionId);
            }
            catch (ResolveException e1) {
                throw new InstallException(MessageFormat.format("Failed to resolve extension [{0}]", extensionId), e1);
            }
        }
        return extension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalExtension installExtension(LocalExtension previousExtension, Extension extension, boolean dependency, String namespace) throws ComponentLookupException, InstallException, LocalExtensionRepositoryException {
        for (ExtensionDependency localExtension2 : extension.getDependencies()) {
            this.installExtensionDependency(localExtension2, namespace);
        }
        this.notifyPushLevelProgress(2);
        try {
            LocalExtension localExtension = extension instanceof LocalExtension ? (LocalExtension)extension : this.localExtensionRepository.storeExtension(extension);
            this.notifyStepPropress();
            if (previousExtension != null) {
                this.extensionHandlerManager.upgrade(previousExtension, localExtension, namespace);
                try {
                    this.localExtensionRepository.uninstallExtension(previousExtension, namespace);
                }
                catch (UninstallException uninstallException) {
                    this.logger.error("Failed to uninstall extension [" + previousExtension + "]", (Throwable)uninstallException);
                }
                this.localExtensionRepository.installExtension(localExtension, namespace, dependency);
                this.observationManager.notify((Event)new ExtensionUpgradedEvent(localExtension.getId()), (Object)localExtension, (Object)previousExtension);
            } else {
                this.extensionHandlerManager.install(localExtension, namespace);
                this.localExtensionRepository.installExtension(localExtension, namespace, dependency);
                this.observationManager.notify((Event)new ExtensionInstalledEvent(localExtension.getId()), (Object)localExtension, (Object)previousExtension);
            }
            if (namespace != null) {
                this.logger.info("Successfully installed extension [{}] on namespace [{}]", (Object)localExtension, (Object)namespace);
            } else {
                this.logger.info("Successfully installed extension [{}]", (Object)localExtension);
            }
            LocalExtension localExtension2 = localExtension;
            return localExtension2;
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }
}

