/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.internal;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.event.ExtensionUninstalledEvent;
import org.xwiki.extension.handler.ExtensionHandlerManager;
import org.xwiki.extension.job.UninstallRequest;
import org.xwiki.extension.job.internal.AbstractJob;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.observation.event.Event;

@Component
@Named(value="uninstall")
public class UninstallJob
extends AbstractJob<UninstallRequest> {
    @Inject
    private LocalExtensionRepository localExtensionRepository;
    @Inject
    private ExtensionHandlerManager extensionHandlerManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void start() throws Exception {
        List<ExtensionId> extensions = ((UninstallRequest)this.getRequest()).getExtensions();
        this.notifyPushLevelProgress(extensions.size());
        try {
            for (ExtensionId extensionId : extensions) {
                if (extensionId.getVersion() != null) {
                    LocalExtension localExtension = (LocalExtension)this.localExtensionRepository.resolve(extensionId);
                    if (((UninstallRequest)this.getRequest()).hasNamespaces()) {
                        this.uninstallExtension(localExtension, ((UninstallRequest)this.getRequest()).getNamespaces());
                    } else if (localExtension.getNamespaces() != null) {
                        this.uninstallExtension(localExtension, localExtension.getNamespaces());
                    } else {
                        this.uninstallExtension(localExtension, (String)null);
                    }
                } else if (((UninstallRequest)this.getRequest()).hasNamespaces()) {
                    this.uninstallExtension(extensionId.getId(), ((UninstallRequest)this.getRequest()).getNamespaces());
                } else {
                    this.uninstallExtension(extensionId.getId(), (String)null);
                }
                this.notifyStepPropress();
            }
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstallExtension(String extensionId, Collection<String> namespaces) throws UninstallException {
        this.notifyPushLevelProgress(namespaces.size());
        try {
            for (String namespace : namespaces) {
                this.uninstallExtension(extensionId, namespace);
                this.notifyStepPropress();
            }
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }

    public void uninstallExtension(String extensionId, String namespace) throws UninstallException {
        LocalExtension localExtension = this.localExtensionRepository.getInstalledExtension(extensionId, namespace);
        if (localExtension == null) {
            throw new UninstallException(MessageFormat.format("[{0}]: extension is not installed", extensionId));
        }
        try {
            this.uninstallExtension(localExtension, namespace);
        }
        catch (Exception e) {
            throw new UninstallException("Failed to uninstall extension", e);
        }
    }

    public void uninstallExtension(LocalExtension localExtension, Collection<String> namespaces) throws UninstallException {
        for (String namespace : namespaces) {
            this.uninstallExtension(localExtension, namespace);
        }
    }

    public void uninstallExtensions(Collection<LocalExtension> extensions, String namespace) throws UninstallException {
        for (LocalExtension backardDependency : extensions) {
            this.uninstallExtension(backardDependency, namespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstallExtension(LocalExtension localExtension, String namespace) throws UninstallException {
        if (namespace != null && !localExtension.isInstalled(namespace)) {
            throw new UninstallException(MessageFormat.format("[{0}]: extension is not installed on wiki [{1}]", localExtension, namespace));
        }
        if (namespace != null) {
            this.logger.info("Uninstalling extension [{}] from namespace [{}]", (Object)localExtension, (Object)namespace);
        } else {
            this.logger.info("Uninstalling extension [{}]", (Object)localExtension);
        }
        this.notifyPushLevelProgress(3);
        try {
            try {
                if (namespace != null) {
                    this.uninstallExtensions(this.localExtensionRepository.getBackwardDependencies(localExtension.getId().getId(), namespace), namespace);
                } else {
                    for (Map.Entry<String, Collection<LocalExtension>> entry : this.localExtensionRepository.getBackwardDependencies(localExtension.getId()).entrySet()) {
                        this.uninstallExtensions(entry.getValue(), entry.getKey());
                    }
                }
            }
            catch (ResolveException e) {
                throw new UninstallException("Failed to resolve backward dependencies of extension [" + localExtension + "]", e);
            }
            this.notifyStepPropress();
            this.extensionHandlerManager.uninstall(localExtension, namespace);
            this.notifyStepPropress();
            this.localExtensionRepository.uninstallExtension(localExtension, namespace);
        }
        finally {
            this.notifyPopLevelProgress();
        }
        this.observationManager.notify((Event)new ExtensionUninstalledEvent(localExtension.getId()), (Object)localExtension, null);
    }
}

