/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionManagerConfiguration;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.internal.VersionManager;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryId;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepositoryException;
import org.xwiki.extension.repository.internal.DefaultInstalledExtension;
import org.xwiki.extension.repository.internal.DefaultLocalExtension;
import org.xwiki.extension.repository.internal.ExtensionStorage;

@Component
@Singleton
public class DefaultLocalExtensionRepository
implements LocalExtensionRepository,
Initializable {
    @Inject
    private ExtensionManagerConfiguration configuration;
    @Inject
    private CoreExtensionRepository coreExtensionRepository;
    @Inject
    private VersionManager versionManager;
    @Inject
    private Logger logger;
    private ExtensionRepositoryId repositoryId;
    private ExtensionStorage storage;
    private Map<ExtensionId, DefaultLocalExtension> extensions = new ConcurrentHashMap<ExtensionId, DefaultLocalExtension>();
    private Map<String, List<DefaultLocalExtension>> extensionsById = new ConcurrentHashMap<String, List<DefaultLocalExtension>>();
    private Map<String, Map<String, DefaultInstalledExtension>> installedExtensions = new ConcurrentHashMap<String, Map<String, DefaultInstalledExtension>>();

    public void initialize() throws InitializationException {
        this.storage = new ExtensionStorage(this, this.configuration.getLocalRepository());
        this.repositoryId = new ExtensionRepositoryId("local", "xwiki", this.storage.getRootFolder().toURI());
        this.storage.loadExtensions();
        HashMap<String, Set<String>> validatedExtension = new HashMap<String, Set<String>>();
        for (List<DefaultLocalExtension> extensionVersions : this.extensionsById.values()) {
            ListIterator<DefaultLocalExtension> it = extensionVersions.listIterator(extensionVersions.size());
            while (it.hasPrevious()) {
                DefaultLocalExtension localExtension = it.previous();
                this.validateExtension(localExtension, validatedExtension);
            }
        }
    }

    private void validateExtension(DefaultLocalExtension localExtension, Map<String, Set<String>> validatedExtensions) {
        if (localExtension.getNamespaces() == null) {
            this.validateExtension(localExtension, validatedExtensions, null);
        } else {
            for (String namespace : localExtension.getNamespaces()) {
                this.validateExtension(localExtension, validatedExtensions, namespace);
            }
        }
    }

    private void validateExtension(DefaultLocalExtension localExtension, Map<String, Set<String>> validatedExtensions, String namespace) {
        Set<String> validatedExtensionsNamespace = validatedExtensions.get(namespace);
        if (validatedExtensionsNamespace == null) {
            validatedExtensionsNamespace = new HashSet<String>();
            validatedExtensions.put(namespace, validatedExtensionsNamespace);
        }
        if (!validatedExtensionsNamespace.contains(localExtension.getId().getId())) {
            this.validateExtension(localExtension, validatedExtensionsNamespace, namespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateExtension(DefaultLocalExtension localExtension, Set<String> validatedExtensions, String namespace) {
        try {
            if (!localExtension.isInstalled(namespace) || this.coreExtensionRepository.exists(localExtension.getId().getId())) {
                localExtension.setInstalled(false, namespace);
                return;
            }
            for (ExtensionDependency extensionDependency : localExtension.getDependencies()) {
                boolean enabled = false;
                List<DefaultLocalExtension> dependencyVersions = this.extensionsById.get(extensionDependency.getId());
                if (dependencyVersions != null) {
                    ListIterator<DefaultLocalExtension> it = dependencyVersions.listIterator(dependencyVersions.size());
                    while (it.hasPrevious()) {
                        DefaultLocalExtension dependencyExtension = it.previous();
                        if (!validatedExtensions.contains(extensionDependency.getId())) {
                            this.validateExtension(dependencyExtension, validatedExtensions, namespace);
                        }
                        if (!dependencyExtension.isInstalled(namespace)) continue;
                        enabled = true;
                        break;
                    }
                } else {
                    enabled = this.coreExtensionRepository.exists(extensionDependency.getId());
                }
                if (enabled) continue;
                localExtension.setInstalled(false, namespace);
                return;
            }
            this.addInstalledExtension(localExtension, namespace);
        }
        finally {
            validatedExtensions.add(localExtension.getId().getId());
        }
    }

    private void uninstallLocalExtension(DefaultLocalExtension localExtension, String namespace) throws UninstallException {
        localExtension.setInstalled(false, namespace);
        try {
            this.storage.saveDescriptor(localExtension);
        }
        catch (Exception e) {
            throw new UninstallException("Failed to modify extension descriptor", e);
        }
        this.removeFromBackwardDependencies(localExtension);
    }

    private void installLocalExtension(DefaultLocalExtension localExtension, String namespace) throws InstallException {
        localExtension.setInstalled(true, namespace);
        try {
            this.storage.saveDescriptor(localExtension);
        }
        catch (Exception e) {
            throw new InstallException("Failed to modify extension descriptor", e);
        }
        this.addInstalledExtension(localExtension, namespace);
    }

    private void removeFromBackwardDependencies(LocalExtension localExtension) {
        Collection<String> namespaces = localExtension.getNamespaces();
        if (namespaces == null) {
            this.installedExtensions.remove(localExtension.getId().getId());
        } else {
            Map<String, DefaultInstalledExtension> namespaceBackwardDependencies = this.installedExtensions.get(localExtension.getId().getId());
            for (String namespace : namespaces) {
                namespaceBackwardDependencies.remove(namespace);
            }
        }
    }

    protected void addLocalExtension(DefaultLocalExtension localExtension) {
        this.extensions.put(localExtension.getId(), localExtension);
        List<DefaultLocalExtension> versions = this.extensionsById.get(localExtension.getId().getId());
        if (versions == null) {
            versions = new ArrayList<DefaultLocalExtension>();
            this.extensionsById.put(localExtension.getId().getId(), versions);
            versions.add(localExtension);
        } else {
            int index;
            for (index = 0; index < versions.size() && this.versionManager.compareVersions(localExtension.getId().getVersion(), versions.get(index).getId().getVersion()) > 0; ++index) {
            }
            versions.add(index, localExtension);
        }
    }

    private DefaultInstalledExtension addInstalledExtension(DefaultLocalExtension localExtension, String namespace) {
        DefaultInstalledExtension installedExtension = this.getInstalledExtensionFromCache(localExtension.getId().getId(), namespace, localExtension, true);
        for (String string : localExtension.getFeatures()) {
            this.getInstalledExtensionFromCache(string, namespace, localExtension, true);
        }
        for (ExtensionDependency extensionDependency : localExtension.getDependencies()) {
            if (this.coreExtensionRepository.exists(extensionDependency.getId())) continue;
            DefaultInstalledExtension dependencyExtension = this.getInstalledExtensionFromCache(extensionDependency.getId(), namespace);
            if (dependencyExtension == null) {
                this.logger.error("Requeired dependency [" + extensionDependency + "] is not installed when registering [" + localExtension + "]");
            }
            dependencyExtension.addBackwardDependency(localExtension);
        }
        return installedExtension;
    }

    private DefaultInstalledExtension getInstalledExtensionFromCache(String feature, String namespace, DefaultLocalExtension localExtension, boolean create) {
        DefaultInstalledExtension installedExtension;
        Map<String, DefaultInstalledExtension> installedExtensionsForFeature = this.installedExtensions.get(feature);
        if (installedExtensionsForFeature == null) {
            installedExtensionsForFeature = new HashMap<String, DefaultInstalledExtension>();
            this.installedExtensions.put(feature, installedExtensionsForFeature);
        }
        if ((installedExtension = installedExtensionsForFeature.get(namespace)) == null) {
            installedExtension = new DefaultInstalledExtension(localExtension, feature, namespace);
            installedExtensionsForFeature.put(namespace, installedExtension);
        }
        return installedExtension;
    }

    private DefaultInstalledExtension getInstalledExtensionFromCache(String feature, String namespace) {
        Map<String, DefaultInstalledExtension> installedExtensionsForFeature = this.installedExtensions.get(feature);
        if (installedExtensionsForFeature == null) {
            return null;
        }
        DefaultInstalledExtension installedExtension = installedExtensionsForFeature.get(namespace);
        if (installedExtension == null) {
            return null;
        }
        return installedExtension;
    }

    @Override
    public Extension resolve(ExtensionId extensionId) throws ResolveException {
        LocalExtension localExtension = this.extensions.get(extensionId);
        if (localExtension == null) {
            throw new ResolveException("Can't find extension [" + extensionId + "]");
        }
        return localExtension;
    }

    @Override
    public boolean exists(ExtensionId extensionId) {
        return this.extensions.containsKey(extensionId);
    }

    @Override
    public ExtensionRepositoryId getId() {
        return this.repositoryId;
    }

    @Override
    public Collection<LocalExtension> getLocalExtensions() {
        return Collections.unmodifiableCollection(this.extensions.values());
    }

    public List<LocalExtension> getInstalledExtensions(String namespace) {
        ArrayList<LocalExtension> result = new ArrayList<LocalExtension>(this.extensions.size());
        for (DefaultLocalExtension localExtension : this.extensions.values()) {
            if (!localExtension.isInstalled(namespace)) continue;
            result.add(localExtension);
        }
        return result;
    }

    public List<LocalExtension> getInstalledExtensions() {
        ArrayList<LocalExtension> result = new ArrayList<LocalExtension>(this.extensions.size());
        for (DefaultLocalExtension localExtension : this.extensions.values()) {
            if (!localExtension.isInstalled()) continue;
            result.add(localExtension);
        }
        return result;
    }

    @Override
    public LocalExtension getInstalledExtension(String feature, String namespace) {
        DefaultInstalledExtension installedExtension = this.getInstalledExtensionFromCache(feature, namespace);
        if (installedExtension != null) {
            return installedExtension.getExtension();
        }
        return null;
    }

    private DefaultLocalExtension createExtension(Extension extension) {
        DefaultLocalExtension localExtension = new DefaultLocalExtension(this, extension);
        localExtension.setFile(this.storage.getExtensionFile(localExtension.getId(), localExtension.getType()));
        return localExtension;
    }

    @Override
    public int countExtensions() {
        return this.extensions.size();
    }

    @Override
    public LocalExtension storeExtension(Extension extension) throws LocalExtensionRepositoryException {
        DefaultLocalExtension localExtension = this.extensions.get(extension.getId());
        if (localExtension == null) {
            try {
                localExtension = this.createExtension(extension);
                extension.download(localExtension.getFile());
                this.storage.saveDescriptor(localExtension);
                this.addLocalExtension(localExtension);
            }
            catch (Exception e) {
                throw new LocalExtensionRepositoryException("Failed to save extensoin [" + extension + "] descriptor", e);
            }
        } else {
            throw new LocalExtensionRepositoryException("Extension [" + extension + "] already exists in local repository");
        }
        return localExtension;
    }

    @Override
    public void removeExtension(LocalExtension extension) throws ResolveException {
        LocalExtension localExtension = (LocalExtension)this.resolve(extension.getId());
        this.storage.removeExtension(localExtension);
    }

    @Override
    public void installExtension(LocalExtension extension, String namespace, boolean dependency) throws InstallException {
        DefaultLocalExtension localExtension = this.extensions.get(extension.getId());
        if (localExtension != null) {
            if (dependency || localExtension.getProperty("local.dependency") == null) {
                localExtension.setDependency(dependency);
            }
            this.installLocalExtension(localExtension, namespace);
        }
    }

    @Override
    public void uninstallExtension(LocalExtension localExtension, String namespace) throws UninstallException {
        LocalExtension existingExtension = this.getInstalledExtension(localExtension.getId().getId(), namespace);
        if (existingExtension == localExtension) {
            this.uninstallLocalExtension((DefaultLocalExtension)localExtension, namespace);
        }
    }

    @Override
    public Collection<LocalExtension> getBackwardDependencies(String feature, String namespace) throws ResolveException {
        DefaultInstalledExtension installedExtension;
        if (this.getInstalledExtension(feature, namespace) == null) {
            throw new ResolveException("Extension [" + feature + "] does is not installed");
        }
        Map<String, DefaultInstalledExtension> installedExtensionsByFeature = this.installedExtensions.get(feature);
        if (installedExtensionsByFeature != null && (installedExtension = installedExtensionsByFeature.get(namespace)) != null) {
            Set<DefaultLocalExtension> backwardDependencies = installedExtension.getBackwardDependencies();
            return backwardDependencies != null ? Collections.unmodifiableCollection(backwardDependencies) : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, Collection<LocalExtension>> getBackwardDependencies(ExtensionId extensionId) throws ResolveException {
        Map<String, Collection<LocalExtension>> result;
        DefaultLocalExtension localExtension = (DefaultLocalExtension)this.resolve(extensionId);
        Collection<String> namespaces = localExtension.getNamespaces();
        Map<String, DefaultInstalledExtension> installedExtensionsByFeature = this.installedExtensions.get(localExtension.getId().getId());
        if (installedExtensionsByFeature != null) {
            result = new HashMap();
            for (DefaultInstalledExtension installedExtension : installedExtensionsByFeature.values()) {
                if (namespaces != null && !namespaces.contains(installedExtension.getNamespace())) continue;
                result.put(installedExtension.getNamespace(), Collections.unmodifiableCollection(installedExtension.getBackwardDependencies()));
            }
        } else {
            result = Collections.emptyMap();
        }
        return result;
    }
}

