/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.handler.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionException;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.handler.ExtensionHandlerManager;
import org.xwiki.extension.handler.ExtensionInitializer;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepository;

@Component
@Singleton
public class DefaultExtensionInitializer
implements ExtensionInitializer {
    @Inject
    private LocalExtensionRepository localExtensionRepository;
    @Inject
    private ExtensionHandlerManager extensionHandlerManager;
    @Inject
    private CoreExtensionRepository coreExtensionRepository;
    @Inject
    private Logger logger;

    @Override
    public void initialize() {
        this.initialize(null, null);
    }

    @Override
    public void initialize(String namespaceToLoad) {
        this.initialize(namespaceToLoad, null);
    }

    @Override
    public void initialize(String namespaceToLoad, String type) {
        HashMap<String, Set<LocalExtension>> loadedExtensions = new HashMap<String, Set<LocalExtension>>();
        Collection<LocalExtension> localExtensions = namespaceToLoad != null ? this.localExtensionRepository.getInstalledExtensions(namespaceToLoad) : this.localExtensionRepository.getInstalledExtensions();
        for (LocalExtension localExtension : localExtensions) {
            if (type != null && !type.equals(localExtension.getType())) continue;
            try {
                this.loadExtension(localExtension, namespaceToLoad, loadedExtensions);
            }
            catch (Exception e) {
                this.logger.error("Failed to initialize local extension [" + localExtension + "]", (Throwable)e);
            }
        }
    }

    private void loadExtension(LocalExtension localExtension, String namespaceToLoad, Map<String, Set<LocalExtension>> loadedExtensions) throws ExtensionException {
        if (localExtension.getNamespaces() != null) {
            if (namespaceToLoad == null) {
                for (String namespace : localExtension.getNamespaces()) {
                    this.loadExtensionInNamespace(localExtension, namespace, loadedExtensions);
                }
            } else if (localExtension.getNamespaces().contains(namespaceToLoad)) {
                this.loadExtensionInNamespace(localExtension, namespaceToLoad, loadedExtensions);
            }
        } else if (namespaceToLoad == null) {
            this.loadExtensionInNamespace(localExtension, null, loadedExtensions);
        }
    }

    private void loadExtensionInNamespace(LocalExtension localExtension, String namespace, Map<String, Set<LocalExtension>> loadedExtensions) throws ExtensionException {
        Set<LocalExtension> loadedExtensionsInNamespace = loadedExtensions.get(namespace);
        if (loadedExtensionsInNamespace == null) {
            loadedExtensionsInNamespace = new HashSet<LocalExtension>();
            loadedExtensions.put(namespace, loadedExtensionsInNamespace);
        }
        if (!loadedExtensionsInNamespace.contains(localExtension)) {
            for (ExtensionDependency extensionDependency : localExtension.getDependencies()) {
                if (this.coreExtensionRepository.exists(extensionDependency.getId())) continue;
                LocalExtension dependencyExtension = this.localExtensionRepository.getInstalledExtension(extensionDependency.getId(), namespace);
                this.loadExtensionInNamespace(dependencyExtension, namespace, loadedExtensions);
            }
            this.extensionHandlerManager.initialize(localExtension, namespace);
            loadedExtensionsInNamespace.add(localExtension);
        }
    }
}

