/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal;

import java.util.regex.Pattern;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.internal.VersionManager;

@Component
@Singleton
public class DefaultVersionManager
implements VersionManager {
    private static final Pattern SEPARATORS = Pattern.compile("[\\.-]");

    @Override
    public int compareVersions(String version1, String version2) {
        if (version1 == null) {
            return -1;
        }
        if (version2 == null) {
            return 1;
        }
        String[] elements1 = SEPARATORS.split(version1);
        String[] elements2 = SEPARATORS.split(version2);
        for (int i = 0; i < elements1.length; ++i) {
            int result = elements2.length == i ? 1 : this.compareElement(elements1[i], elements2[i]);
            if (result == 0) continue;
            return result;
        }
        return elements2.length > elements1.length ? -1 : 0;
    }

    private int compareElement(String element1, String element2) {
        Integer value1 = this.convertElement(element1);
        Integer value2 = this.convertElement(element2);
        if (value1 != null && value2 != null) {
            return value1 - value2;
        }
        return element1.compareTo(element2);
    }

    private Integer convertElement(String element) {
        try {
            return Integer.valueOf(element);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

