/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionManager;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.repository.LocalExtensionRepository;

@Component
@Singleton
public class DefaultExtensionManager
implements ExtensionManager {
    @Inject
    private ExtensionRepositoryManager repositoryManager;
    @Inject
    private CoreExtensionRepository coreExtensionRepository;
    @Inject
    private LocalExtensionRepository localExtensionRepository;

    @Override
    public Extension resolveExtension(ExtensionId extensionId) throws ResolveException {
        Extension extension = null;
        extension = this.coreExtensionRepository.getCoreExtension(extensionId.getId());
        if (extension == null) {
            try {
                extension = this.localExtensionRepository.resolve(extensionId);
            }
            catch (ResolveException e) {
                extension = this.repositoryManager.resolve(extensionId);
            }
        }
        return extension;
    }

    @Override
    public Extension resolveExtension(ExtensionDependency extensionDependency) throws ResolveException {
        Extension extension = null;
        String initialId = extensionDependency.getId();
        extension = this.coreExtensionRepository.getCoreExtension(initialId);
        if (extension == null) {
            try {
                extension = this.localExtensionRepository.resolve(extensionDependency);
            }
            catch (ResolveException e) {
                extension = this.repositoryManager.resolve(extensionDependency);
            }
        }
        return extension;
    }
}

