/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.event;

import org.apache.commons.lang3.StringUtils;
import org.xwiki.extension.job.Request;
import org.xwiki.extension.job.event.JobEvent;

abstract class AbstractJobEvent
implements JobEvent {
    private static final long serialVersionUID = 1L;
    private Request request;
    private String jobId;
    private String jobType;

    public AbstractJobEvent() {
    }

    protected AbstractJobEvent(String jobType) {
        this.jobType = jobType;
    }

    protected AbstractJobEvent(String jobId, String jobType, Request request) {
        this.jobId = jobId;
        this.jobType = jobType;
        this.request = request;
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    @Override
    public String getJobType() {
        return this.jobType;
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    public boolean matches(Object event) {
        return this.getClass() == event.getClass() && this.matchesJobId((JobEvent)event) && this.matchesJobType((JobEvent)event);
    }

    private boolean matchesJobId(JobEvent event) {
        return this.jobId == null || StringUtils.equals((CharSequence)this.jobId, (CharSequence)event.getJobId());
    }

    private boolean matchesJobType(JobEvent event) {
        return this.jobId == null || StringUtils.equals((CharSequence)this.jobId, (CharSequence)event.getJobId());
    }
}

