/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal.local;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.xwiki.extension.AbstractExtension;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.repository.internal.local.DefaultLocalExtensionFile;
import org.xwiki.extension.repository.internal.local.DefaultLocalExtensionRepository;

public class DefaultLocalExtension
extends AbstractExtension
implements LocalExtension {
    private Set<String> namespaces;
    private File descriptorFile;

    public DefaultLocalExtension(DefaultLocalExtensionRepository repository, ExtensionId id, String type) {
        super(repository, id, type);
    }

    public DefaultLocalExtension(DefaultLocalExtensionRepository repository, Extension extension) {
        super(repository, extension);
    }

    public File getDescriptorFile() {
        return this.descriptorFile;
    }

    public void setDescriptorFile(File descriptorFile) {
        this.descriptorFile = descriptorFile;
    }

    public void setFile(File file) {
        this.setFile(new DefaultLocalExtensionFile(file));
        this.putProperty("local.file", file);
    }

    @Override
    public Collection<String> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Collection<String> namespaces) {
        this.namespaces = namespaces != null ? new HashSet<String>(namespaces) : null;
    }

    public void addNamespace(String namespace) {
        if (this.namespaces == null) {
            this.namespaces = new HashSet<String>();
        }
        this.namespaces.add(namespace);
    }

    @Override
    public DefaultLocalExtensionFile getFile() {
        return (DefaultLocalExtensionFile)super.getFile();
    }

    @Override
    public boolean isInstalled() {
        return this.getProperty("local.installed", false);
    }

    @Override
    public boolean isInstalled(String namespace) {
        return this.isInstalled() && (this.namespaces == null || this.namespaces.contains(namespace));
    }

    public void setInstalled(boolean installed) {
        this.putProperty("local.installed", installed);
    }

    public void setInstalled(boolean installed, String namespace) {
        if (namespace == null) {
            this.setInstalled(installed);
            this.setNamespaces(null);
        } else if (installed) {
            this.setInstalled(true);
            this.addNamespace(namespace);
        } else if (this.namespaces != null) {
            this.namespaces.remove(namespace);
            if (this.namespaces.isEmpty()) {
                this.setInstalled(false);
                this.namespaces = null;
            }
        }
    }

    @Override
    public boolean isDependency() {
        return this.getProperty("local.dependency", false);
    }

    public void setDependency(boolean dependency) {
        this.putProperty("local.dependency", dependency);
    }
}

