/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.internal;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.job.Job;
import org.xwiki.extension.job.JobException;
import org.xwiki.extension.job.JobManager;
import org.xwiki.extension.job.Request;
import org.xwiki.extension.job.event.status.JobStatus;

@Component
@Singleton
public class DefaultJobManager
implements JobManager,
Runnable,
Initializable {
    @Inject
    private ComponentManager componentManager;
    private volatile Job currentJob;
    private BlockingQueue<JobElement> jobQueue = new LinkedBlockingQueue<JobElement>();
    private Thread thread;

    public void initialize() throws InitializationException {
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.thread.isInterrupted()) {
            try {
                JobElement element = this.jobQueue.take();
                this.currentJob = element.job;
                DefaultJobManager defaultJobManager = this;
                synchronized (defaultJobManager) {
                    this.currentJob.start(element.request);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    @Override
    public Job getCurrentJob() {
        return this.currentJob;
    }

    private Job createJob(String jobType) throws JobException {
        Job job;
        try {
            job = (Job)this.componentManager.lookup(Job.class, jobType);
        }
        catch (ComponentLookupException e) {
            throw new JobException("Failed to lookup any Job for role hint [" + jobType + "]", e);
        }
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Job executeJob(String jobType, Request request) throws JobException {
        if (this.jobQueue.isEmpty() && this.currentJob != null && this.currentJob.getStatus().getState() != JobStatus.State.FINISHED) {
            throw new JobException("A task is already running");
        }
        DefaultJobManager defaultJobManager = this;
        synchronized (defaultJobManager) {
            this.currentJob = this.createJob(jobType);
            this.currentJob.start(request);
        }
        return this.currentJob;
    }

    @Override
    public Job addJob(String jobType, Request request) throws JobException {
        Job job = this.createJob(jobType);
        this.jobQueue.add(new JobElement(job, request));
        return job;
    }

    private static class JobElement {
        public Job job;
        public Request request;

        public JobElement(Job job, Request request) {
            this.job = job;
            this.request = request;
        }
    }
}

