/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.cluster.internal;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.cluster.internal.RemoteJobStartedEvent;
import org.xwiki.job.AbstractRequest;
import org.xwiki.job.DefaultRequest;
import org.xwiki.job.Request;
import org.xwiki.job.event.JobStartedEvent;
import org.xwiki.observation.event.Event;
import org.xwiki.observation.remote.LocalEventData;
import org.xwiki.observation.remote.RemoteEventData;
import org.xwiki.observation.remote.converter.AbstractEventConverter;

@Component
@Singleton
@Named(value="ExtensionJob")
public class ExtensionJobEventConverter
extends AbstractEventConverter {
    private static final Set<String> JOBS = new HashSet<String>(){
        {
            this.add("uninstall");
            this.add("install");
        }
    };

    public boolean toRemote(LocalEventData localEvent, RemoteEventData remoteEvent) {
        JobStartedEvent jobEvent;
        if (localEvent.getEvent() instanceof JobStartedEvent && JOBS.contains((jobEvent = (JobStartedEvent)localEvent.getEvent()).getJobId())) {
            remoteEvent.setEvent((Serializable)jobEvent);
            return true;
        }
        return false;
    }

    public boolean fromRemote(RemoteEventData remoteEvent, LocalEventData localEvent) {
        if (remoteEvent.getEvent() instanceof JobStartedEvent) {
            JobStartedEvent jobEvent = (JobStartedEvent)remoteEvent.getEvent();
            Request request = jobEvent.getRequest();
            if (!(request instanceof AbstractRequest)) {
                request = new DefaultRequest(request);
            }
            ((AbstractRequest)request).setRemote(true);
            localEvent.setEvent((Event)new RemoteJobStartedEvent(jobEvent.getJobType(), request));
            return true;
        }
        return false;
    }
}

