/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.cluster.internal;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.cluster.internal.RemoteJobStartedEvent;
import org.xwiki.job.Job;
import org.xwiki.job.JobException;
import org.xwiki.job.JobManager;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.event.LogEvent;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="extension.cluster")
@Singleton
public class RemoteListener
implements EventListener {
    public static final String LISTENERID = "extension.cluster";
    private static final List<Event> EVENTS = Arrays.asList(new Event[]{new RemoteJobStartedEvent()});
    @Inject
    private JobManager jobManager;
    @Inject
    private Logger logger;

    public List<Event> getEvents() {
        return EVENTS;
    }

    public String getName() {
        return LISTENERID;
    }

    public void onEvent(Event event, Object data, Object source) {
        RemoteJobStartedEvent jobEvent = (RemoteJobStartedEvent)event;
        try {
            Job job = this.jobManager.addJob(jobEvent.getJobType(), jobEvent.getRequest());
            for (LogEvent log : job.getStatus().getLog(LogLevel.ERROR)) {
                this.logger.error(log.getMessage(), log.getArgumentArray());
            }
        }
        catch (JobException e) {
            this.logger.error("Failed to execute remote job [" + (Object)((Object)jobEvent) + "]", (Throwable)e);
        }
    }
}

