/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal.job;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.ObjectUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.distribution.internal.DistributionManager;
import org.xwiki.extension.distribution.internal.job.DistributionJobStatus;
import org.xwiki.extension.distribution.internal.job.DistributionQuestion;
import org.xwiki.extension.distribution.internal.job.DistributionRequest;
import org.xwiki.extension.distribution.internal.job.DistributionStepStatus;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.job.AbstractJob;
import org.xwiki.job.internal.AbstractJobStatus;

@Component
@Named(value="distribution")
public class DistributionJob
extends AbstractJob<DistributionRequest> {
    @Inject
    private DistributionManager distributionManager;
    @Inject
    private InstalledExtensionRepository installedRepository;

    public String getType() {
        return "distribution";
    }

    protected AbstractJobStatus<DistributionRequest> createNewStatus(DistributionRequest request) {
        InstalledExtension installedExtension;
        ArrayList<DistributionStepStatus> steps = new ArrayList<DistributionStepStatus>(3);
        ExtensionId extensionUI = this.distributionManager.getUIExtensionId();
        DistributionStepStatus step1 = new DistributionStepStatus("extension.mainui");
        steps.add(step1);
        step1.setUpdateState(DistributionStepStatus.UpdateState.COMPLETED);
        if (!(extensionUI == null || (installedExtension = this.installedRepository.getInstalledExtension(extensionUI.getId(), "wiki:xwiki")) != null && installedExtension.getId().getVersion().equals(extensionUI.getVersion()))) {
            step1.setUpdateState(null);
        }
        DistributionStepStatus step2 = new DistributionStepStatus("extension.outdatedextensions");
        steps.add(step2);
        step2.setUpdateState(DistributionStepStatus.UpdateState.COMPLETED);
        block0: for (InstalledExtension extension : this.installedRepository.getInstalledExtensions()) {
            Collection namespaces = extension.getNamespaces();
            if (namespaces == null) {
                if (extension.isValid(null)) continue;
                step2.setUpdateState(null);
                break;
            }
            for (String namespace : namespaces) {
                if (extension.isValid(namespace)) continue;
                step2.setUpdateState(null);
                continue block0;
            }
        }
        for (DistributionStepStatus step : steps) {
            if (step.getUpdateState() != null) continue;
            steps.add(0, new DistributionStepStatus("welcome"));
            break;
        }
        DistributionJobStatus status = new DistributionJobStatus(request, this.observationManager, this.loggerManager, steps);
        if (this.distributionManager.getDistributionExtension() != null) {
            DistributionJobStatus previousStatus = this.distributionManager.getPreviousJobStatus();
            if (previousStatus != null && previousStatus.getDistributionExtension() != null && !ObjectUtils.equals((Object)previousStatus.getDistributionExtension(), (Object)this.distributionManager.getDistributionExtension())) {
                status.setDistributionExtension(previousStatus.getDistributionExtension());
                status.setDistributionExtensionUi(previousStatus.getDistributionExtensionUi());
            }
            status.setDistributionExtension(this.distributionManager.getDistributionExtension().getId());
            status.setDistributionExtensionUi(extensionUI);
        }
        return status;
    }

    protected DistributionJobStatus getDistributionJobStatus() {
        return (DistributionJobStatus)this.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() throws Exception {
        List<DistributionStepStatus> steps = this.getDistributionJobStatus().getSteps();
        this.notifyPushLevelProgress(steps.size());
        try {
            for (int index = 0; index < steps.size(); ++index) {
                this.getDistributionJobStatus().setCurrentStateIndex(index);
                DistributionStepStatus step = steps.get(index);
                if (step.getUpdateState() == null) {
                    DistributionQuestion question = new DistributionQuestion(step.getStepId());
                    this.getStatus().ask((Object)question);
                    if (question.isSave()) {
                        switch (question.getAction()) {
                            case CANCEL_STEP: {
                                step.setUpdateState(DistributionStepStatus.UpdateState.CANCELED);
                                break;
                            }
                            case COMPLETE_STEP: {
                                step.setUpdateState(DistributionStepStatus.UpdateState.COMPLETED);
                                break;
                            }
                            case CANCEL: {
                                while (index < steps.size()) {
                                    steps.get(index).setUpdateState(DistributionStepStatus.UpdateState.CANCELED);
                                    ++index;
                                }
                            }
                            case SKIP: {
                                index = steps.size() - 1;
                                break;
                            }
                        }
                    }
                }
                this.notifyStepPropress();
            }
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }
}

