/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal;

import com.xpn.xwiki.XWikiContext;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.bridge.event.ActionExecutingEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.distribution.internal.DistributionManager;
import org.xwiki.extension.distribution.internal.job.step.UpgradeModeDistributionStep;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.ApplicationStartedEvent;
import org.xwiki.observation.event.Event;

@Component
@Named(value="DistributionInitializerListener")
public class DistributionInitializerListener
implements EventListener {
    private static final List<Event> EVENTS = Arrays.asList(new ApplicationStartedEvent(), new ActionExecutingEvent("view"));
    @Inject
    private DistributionManager distributionManager;

    public List<Event> getEvents() {
        return EVENTS;
    }

    public String getName() {
        return "DistributionInitializerListener";
    }

    public void onEvent(Event event, Object arg1, Object arg2) {
        DistributionManager.DistributionState distributionState = this.distributionManager.getFarmDistributionState();
        if (distributionState != DistributionManager.DistributionState.NONE) {
            if (event instanceof ApplicationStartedEvent) {
                this.distributionManager.startFarmJob();
            } else if (!((XWikiContext)arg2).isMainWiki() && this.distributionManager.getUpgradeMode() == UpgradeModeDistributionStep.UpgradeMode.WIKI) {
                this.startWikiJob(((XWikiContext)arg2).getDatabase());
            }
        }
    }

    private synchronized void startWikiJob(String wiki) {
        if (this.distributionManager.getWikiJob(wiki) == null) {
            this.distributionManager.startWikiJob(wiki);
        }
    }
}

