/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal.job;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.distribution.internal.job.AbstractDistributionJob;
import org.xwiki.extension.distribution.internal.job.DistributionJobStatus;
import org.xwiki.extension.distribution.internal.job.DistributionRequest;
import org.xwiki.extension.distribution.internal.job.WikiDistributionJobStatus;
import org.xwiki.extension.distribution.internal.job.step.DistributionStep;

@Component
@Named(value="wikidistribution")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class WikiDistributionJob
extends AbstractDistributionJob<DistributionRequest, WikiDistributionJobStatus> {
    @Override
    protected List<DistributionStep> createSteps() {
        ArrayList<DistributionStep> steps = new ArrayList<DistributionStep>(3);
        try {
            steps.add((DistributionStep)this.componentManager.getInstance(DistributionStep.class, "extension.defaultui"));
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to get default UI step instance");
        }
        try {
            steps.add((DistributionStep)this.componentManager.getInstance(DistributionStep.class, "extension.outdatedextensions"));
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to get outdated extensions step instance");
        }
        return steps;
    }

    @Override
    public DistributionJobStatus<?> getPreviousStatus() {
        return this.distributionManager.getPreviousWikiJobStatus(((DistributionRequest)this.getRequest()).getWiki());
    }

    @Override
    public ExtensionId getUIExtensionId() {
        return this.distributionManager.getWikiUIExtensionId();
    }

    @Override
    protected WikiDistributionJobStatus createNewDistributionStatus(DistributionRequest request, List<DistributionStep> steps) {
        return new WikiDistributionJobStatus(request, this.observationManager, this.loggerManager, steps);
    }
}

