/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal.job;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.distribution.internal.job.AbstractDistributionJob;
import org.xwiki.extension.distribution.internal.job.DistributionJobStatus;
import org.xwiki.extension.distribution.internal.job.DistributionRequest;
import org.xwiki.extension.distribution.internal.job.FarmDistributionJobStatus;
import org.xwiki.extension.distribution.internal.job.step.DistributionStep;
import org.xwiki.text.StringUtils;

@Component
@Named(value="distribution")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class FarmDistributionJob
extends AbstractDistributionJob<DistributionRequest, FarmDistributionJobStatus> {
    @Override
    protected List<DistributionStep> createSteps() {
        ArrayList<DistributionStep> steps = new ArrayList<DistributionStep>(4);
        try {
            steps.add((DistributionStep)this.componentManager.getInstance(DistributionStep.class, "firstadminuser"));
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to get first admin step instance", (Throwable)e);
        }
        ExtensionId mainUI = this.getUIExtensionId();
        if (mainUI != null && StringUtils.isNotBlank((CharSequence)mainUI.getId())) {
            try {
                steps.add((DistributionStep)this.componentManager.getInstance(DistributionStep.class, "extension.defaultui"));
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to get default UI step instance", (Throwable)e);
            }
        } else {
            try {
                steps.add((DistributionStep)this.componentManager.getInstance(DistributionStep.class, "extension.flavor"));
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to get flavor step instance", (Throwable)e);
            }
        }
        ExtensionId wikiUI = this.distributionManager.getWikiUIExtensionId();
        if (wikiUI != null && StringUtils.isNotBlank((CharSequence)wikiUI.getId())) {
            try {
                steps.add((DistributionStep)this.componentManager.getInstance(DistributionStep.class, "extension.defaultui.wikis"));
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to get all in one default UI step instance", (Throwable)e);
            }
        } else {
            try {
                steps.add((DistributionStep)this.componentManager.getInstance(DistributionStep.class, "extension.flavor.wikis"));
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to get all in one flavor step instance", (Throwable)e);
            }
        }
        try {
            steps.add((DistributionStep)this.componentManager.getInstance(DistributionStep.class, "extension.outdatedextensions"));
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to get outdated extensions step instance", (Throwable)e);
        }
        return steps;
    }

    @Override
    public DistributionJobStatus<?> getPreviousStatus() {
        return this.distributionManager.getPreviousFarmJobStatus();
    }

    @Override
    public ExtensionId getUIExtensionId() {
        return this.distributionManager.getMainUIExtensionId();
    }

    @Override
    protected FarmDistributionJobStatus createNewDistributionStatus(DistributionRequest request, List<DistributionStep> steps) {
        return new FarmDistributionJobStatus(request, this.observationManager, this.loggerManager, steps);
    }
}

