/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.security;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.user.api.XWikiRightService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.xar.XarExtensionConfiguration;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtensionRepository;
import org.xwiki.extension.xar.security.ProtectionLevel;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component(roles={XarSecurityTool.class})
@Singleton
public class XarSecurityTool {
    @Inject
    private XarExtensionConfiguration configuration;
    @Inject
    @Named(value="xar")
    private InstalledExtensionRepository installedXARs;
    @Inject
    private Provider<AuthorizationManager> authorizationProvider;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private Logger logger;
    private AuthorizationManager authorization;

    private AuthorizationManager getAuthorization() {
        if (this.authorization == null) {
            this.authorization = (AuthorizationManager)this.authorizationProvider.get();
        }
        return this.authorization;
    }

    public ProtectionLevel getProtectionLevel(Right right, DocumentReference userReference, DocumentReference documentReference) {
        XarExtensionConfiguration.DocumentProtection protection = this.configuration.getDocumentProtection();
        if (protection != XarExtensionConfiguration.DocumentProtection.NONE && !((XarInstalledExtensionRepository)this.installedXARs).isAllowed(documentReference, right)) {
            if (protection.isDeny() && !XWikiRightService.isSuperAdmin((EntityReference)userReference)) {
                if (!this.getAuthorization().hasAccess(right, userReference, (EntityReference)documentReference)) {
                    return ProtectionLevel.DENY;
                }
                if (this.isForcedDeny(protection, userReference)) {
                    return ProtectionLevel.DENY;
                }
            }
            return ProtectionLevel.WARNING;
        }
        return ProtectionLevel.NONE;
    }

    private boolean isForcedDeny(XarExtensionConfiguration.DocumentProtection protection, DocumentReference userReference) {
        return protection.isForced() && (!protection.isSimple() || this.isSimpleUser(userReference));
    }

    public boolean isSimpleUser(DocumentReference userReference) {
        if (XWikiRightService.isGuest((EntityReference)userReference)) {
            return true;
        }
        if (XWikiRightService.isSuperAdmin((EntityReference)userReference)) {
            return false;
        }
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        if (xcontext != null) {
            try {
                XWikiDocument userDocument = xcontext.getWiki().getDocument(userReference, xcontext);
                if (!userDocument.isNew() && !StringUtils.equals((CharSequence)userDocument.getStringValue("usertype"), (CharSequence)"Advanced")) {
                    return true;
                }
            }
            catch (XWikiException e) {
                this.logger.error("Failed to access document of user [{}]. Assuming advanced user.", (Object)userReference);
            }
        }
        return false;
    }
}

