/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.extension.xar.internal.validator;

import javax.inject.Named;
import javax.inject.Singleton;

import org.xwiki.component.annotation.Component;
import org.xwiki.extension.internal.validator.AbstractExtensionValidator;
import org.xwiki.extension.xar.internal.handler.XarExtensionHandler;
import org.xwiki.security.authorization.Right;

/**
 * Check rights for xar extensions.
 * 
 * @version $Id: 494387a61d65e8c6cb83f9a6d862ece9c5c80607 $
 * @since 9.0RC1
 */
@Component
@Named(XarExtensionHandler.TYPE)
@Singleton
public class XarExtensionValidator extends AbstractExtensionValidator
{
    /**
     * Default constructor.
     */
    public XarExtensionValidator()
    {
        this.entityRight = Right.ADMIN;
    }
}
