/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.handler.packager;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.MandatoryDocumentInitializer;
import com.xpn.xwiki.doc.MandatoryDocumentInitializerManager;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.merge.MergeConfiguration;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.diff.ConflictDecision;
import org.xwiki.extension.xar.XWikiDocumentMerger;
import org.xwiki.extension.xar.XWikiDocumentMergerConfiguration;
import org.xwiki.extension.xar.XarExtensionException;
import org.xwiki.extension.xar.question.ConflictQuestion;
import org.xwiki.job.Job;
import org.xwiki.job.JobContext;
import org.xwiki.logging.LogLevel;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.store.merge.MergeConflictDecisionsManager;
import org.xwiki.store.merge.MergeDocumentResult;
import org.xwiki.store.merge.MergeManager;
import org.xwiki.xar.XarEntryType;

@Component
@Singleton
public class DefaultXWikiDocumentMerger
implements XWikiDocumentMerger {
    @Inject
    private MandatoryDocumentInitializerManager initializerManager;
    @Inject
    private Execution execution;
    @Inject
    private JobContext jobContext;
    @Inject
    private MergeManager mergeManager;
    @Inject
    private MergeConflictDecisionsManager conflictDecisionsManager;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private Logger logger;

    @Override
    public XWikiDocument merge(XWikiDocument currentDocument, XWikiDocument previousDocument, XWikiDocument nextDocument, XWikiDocumentMergerConfiguration configuration) throws XarExtensionException {
        if (previousDocument != null) {
            return this.upgrade(currentDocument, previousDocument, nextDocument, configuration);
        }
        return this.install(currentDocument, nextDocument, configuration);
    }

    private XWikiDocument upgrade(XWikiDocument currentDocument, XWikiDocument previousDocument, XWikiDocument nextDocument, XWikiDocumentMergerConfiguration configuration) {
        XarEntryType.UpgradeType type = configuration.getType();
        if (type != null) {
            switch (type) {
                case OVERWRITE: {
                    return this.OVERWRITE(currentDocument, previousDocument, nextDocument, configuration);
                }
                case SKIP: {
                    return this.SKIP(currentDocument, previousDocument, nextDocument, configuration);
                }
                case SKIP_ALLWAYS: {
                    return this.SKIP_ALLWAYS(currentDocument, previousDocument, nextDocument, configuration);
                }
            }
        }
        return this.THREEWAYS(currentDocument, previousDocument, nextDocument, configuration);
    }

    private XWikiDocument install(XWikiDocument currentDocument, XWikiDocument nextDocument, XWikiDocumentMergerConfiguration configuration) {
        XWikiDocument result = currentDocument;
        if (currentDocument != null) {
            MandatoryDocumentInitializer initializer = this.initializerManager.getMandatoryDocumentInitializer(nextDocument.getDocumentReference());
            XWikiDocument mandatoryDocument = this.getMandatoryDocument(nextDocument.getDocumentReference(), initializer);
            if (mandatoryDocument != null) {
                initializer.updateDocument(nextDocument);
                result = this.merge3(currentDocument, mandatoryDocument, nextDocument, configuration);
            } else if (!currentDocument.equalsData(nextDocument)) {
                result = this.askDocumentToSave(currentDocument, null, nextDocument, configuration, null);
            }
        } else {
            result = nextDocument;
        }
        return result;
    }

    private XWikiDocument THREEWAYS(XWikiDocument currentDocument, XWikiDocument previousDocument, XWikiDocument nextDocument, XWikiDocumentMergerConfiguration configuration) {
        XWikiDocument result = null;
        result = currentDocument != null ? this.merge3(currentDocument, previousDocument, nextDocument, configuration) : this.askDocumentToSave(null, previousDocument, nextDocument, configuration, null);
        return result;
    }

    private XWikiDocument OVERWRITE(XWikiDocument currentDocument, XWikiDocument previousDocument, XWikiDocument nextDocument, XWikiDocumentMergerConfiguration configuration) {
        return nextDocument;
    }

    private XWikiDocument SKIP(XWikiDocument currentDocument, XWikiDocument previousDocument, XWikiDocument nextDocument, XWikiDocumentMergerConfiguration configuration) {
        XWikiDocument result = currentDocument;
        if (currentDocument != null) {
            if (previousDocument != null && currentDocument.equalsData(previousDocument)) {
                result = nextDocument;
            }
        } else if (previousDocument == null) {
            result = nextDocument;
        }
        return result;
    }

    private XWikiDocument SKIP_ALLWAYS(XWikiDocument currentDocument, XWikiDocument previousDocument, XWikiDocument nextDocument, XWikiDocumentMergerConfiguration configuration) {
        XWikiDocument result = currentDocument;
        if (currentDocument == null && previousDocument == null) {
            result = nextDocument;
        }
        return result;
    }

    private XWikiDocument merge3(XWikiDocument currentDocument, XWikiDocument previousDocument, XWikiDocument nextDocument, XWikiDocumentMergerConfiguration configuration) {
        MergeDocumentResult documentMergeResult;
        if (currentDocument.equalsData(previousDocument)) {
            return currentDocument.equalsData(nextDocument) ? currentDocument : nextDocument;
        }
        MergeConfiguration mergeConfiguration = new MergeConfiguration();
        mergeConfiguration.setUserReference((EntityReference)((XWikiContext)this.contextProvider.get()).getUserReference());
        mergeConfiguration.setConcernedDocument(currentDocument.getDocumentReferenceWithLocale());
        mergeConfiguration.setProvidedVersionsModifiables(false);
        try {
            documentMergeResult = this.mergeManager.mergeDocument((DocumentModelBridge)previousDocument, (DocumentModelBridge)nextDocument, (DocumentModelBridge)currentDocument, mergeConfiguration);
        }
        catch (Exception e) {
            documentMergeResult = new MergeDocumentResult((DocumentModelBridge)currentDocument, (DocumentModelBridge)previousDocument, (DocumentModelBridge)nextDocument);
            documentMergeResult.getLog().error("Unexpected exception thrown. Usually means there is a bug in the merge.", (Throwable)e);
            documentMergeResult.setMergeResult((Object)currentDocument.clone());
        }
        documentMergeResult.getLog().log(this.logger);
        return this.askDocumentToSave(currentDocument, previousDocument, nextDocument, configuration, documentMergeResult);
    }

    private XWikiDocument getMandatoryDocument(DocumentReference documentReference, MandatoryDocumentInitializer initializer) {
        XWikiDocument mandatoryDocument;
        if (initializer != null) {
            mandatoryDocument = new XWikiDocument(documentReference);
            if (!initializer.updateDocument(mandatoryDocument)) {
                mandatoryDocument = null;
            }
        } else {
            mandatoryDocument = null;
        }
        return mandatoryDocument;
    }

    private XWikiDocument askDocumentToSave(XWikiDocument currentDocument, XWikiDocument previousDocument, XWikiDocument nextDocument, XWikiDocumentMergerConfiguration configuration, MergeDocumentResult documentMergeResult) {
        XWikiDocument documentToSave;
        ConflictQuestion.ConflictType type;
        DocumentReference userReference;
        XWikiDocument mergedDocument = documentMergeResult != null ? (XWikiDocument)documentMergeResult.getMergeResult() : null;
        if (currentDocument != null) {
            nextDocument.setCreatorReference(currentDocument.getCreatorReference());
        }
        if (mergedDocument != null) {
            mergedDocument.setCreatorReference(currentDocument.getCreatorReference());
        }
        DocumentReference documentReference = userReference = configuration != null ? configuration.getAuthorReference() : null;
        if (userReference != null) {
            nextDocument.setAuthorReference(userReference);
            nextDocument.setContentAuthorReference(userReference);
            for (XWikiAttachment attachment : nextDocument.getAttachmentList()) {
                attachment.setAuthorReference(nextDocument.getAuthorReference());
            }
            if (mergedDocument != null) {
                mergedDocument.setAuthorReference(userReference);
                mergedDocument.setContentAuthorReference(userReference);
                for (XWikiAttachment attachment : mergedDocument.getAttachmentList()) {
                    if (!attachment.isContentDirty()) continue;
                    attachment.setAuthorReference(mergedDocument.getAuthorReference());
                }
            }
        }
        List documentContentConflicts = null;
        if (previousDocument == null) {
            type = ConflictQuestion.ConflictType.CURRENT_EXIST;
        } else if (currentDocument == null) {
            type = ConflictQuestion.ConflictType.CURRENT_DELETED;
        } else if (documentMergeResult != null) {
            if (documentMergeResult.getLog().hasLogLevel(LogLevel.ERROR)) {
                type = ConflictQuestion.ConflictType.MERGE_FAILURE;
                documentContentConflicts = documentMergeResult.getConflicts(MergeDocumentResult.DocumentPart.CONTENT);
            } else {
                type = ConflictQuestion.ConflictType.MERGE_SUCCESS;
            }
        } else {
            type = null;
        }
        ConflictQuestion question = new ConflictQuestion(currentDocument, previousDocument, nextDocument, mergedDocument, type, documentContentConflicts);
        ConflictQuestion.GlobalAction contextAction = this.getMergeConflictAnswer(question.getType(), configuration);
        if (contextAction != null && contextAction != ConflictQuestion.GlobalAction.ASK) {
            question.setGlobalAction(contextAction);
        } else {
            Job job = this.jobContext.getCurrentJob();
            if (job != null && job.getStatus() != null && job.getStatus().getRequest() != null && job.getStatus().getRequest().isInteractive()) {
                try {
                    job.getStatus().ask((Object)question);
                    if (question.isAlways()) {
                        this.setMergeConflictAnswer(question.getType(), question.getGlobalAction());
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        List<ConflictDecision> decisions = question.getDecisions();
        if (question.getGlobalAction() == ConflictQuestion.GlobalAction.MERGED && !decisions.isEmpty()) {
            this.conflictDecisionsManager.setConflictDecisionList(decisions, currentDocument.getDocumentReferenceWithLocale(), (EntityReference)((XWikiContext)this.contextProvider.get()).getUserReference());
            MergeConfiguration mergeConfiguration = new MergeConfiguration();
            mergeConfiguration.setConcernedDocument(currentDocument.getDocumentReferenceWithLocale());
            mergeConfiguration.setUserReference((EntityReference)((XWikiContext)this.contextProvider.get()).getUserReference());
            mergeConfiguration.setProvidedVersionsModifiables(false);
            documentMergeResult = this.mergeManager.mergeDocument((DocumentModelBridge)previousDocument, (DocumentModelBridge)nextDocument, (DocumentModelBridge)currentDocument, mergeConfiguration);
            mergedDocument = (XWikiDocument)documentMergeResult.getMergeResult();
        }
        switch (question.getGlobalAction()) {
            case CURRENT: {
                documentToSave = currentDocument;
                break;
            }
            case NEXT: {
                documentToSave = nextDocument;
                break;
            }
            case PREVIOUS: {
                documentToSave = previousDocument;
                break;
            }
            case CUSTOM: {
                documentToSave = question.getCustomDocument() != null ? question.getCustomDocument() : mergedDocument;
                break;
            }
            default: {
                documentToSave = documentMergeResult == null || documentMergeResult.isModified() ? mergedDocument : currentDocument;
            }
        }
        return documentToSave;
    }

    private ConflictQuestion.GlobalAction getMergeConflictAnswer(ConflictQuestion.ConflictType type, XWikiDocumentMergerConfiguration configuration) {
        ConflictQuestion.GlobalAction action = (ConflictQuestion.GlobalAction)((Object)this.execution.getContext().getProperty(ConflictQuestion.toKey(type)));
        if (action == null && configuration != null) {
            action = configuration.getConflictAction(type);
        }
        return action;
    }

    private void setMergeConflictAnswer(ConflictQuestion.ConflictType type, ConflictQuestion.GlobalAction action) {
        this.execution.getContext().setProperty(ConflictQuestion.toKey(type), (Object)action);
    }
}

