/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.handler;

import com.xpn.xwiki.doc.merge.MergeConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.handler.internal.AbstractExtensionHandler;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.xar.internal.handler.packager.DefaultPackageConfiguration;
import org.xwiki.extension.xar.internal.handler.packager.PackageConfiguration;
import org.xwiki.extension.xar.internal.handler.packager.Packager;
import org.xwiki.extension.xar.internal.handler.packager.XarEntry;
import org.xwiki.extension.xar.internal.handler.packager.XarFile;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtension;
import org.xwiki.job.Job;
import org.xwiki.job.JobContext;
import org.xwiki.job.Request;
import org.xwiki.model.reference.DocumentReference;

@Component
@Singleton
@Named(value="xar")
public class XarExtensionHandler
extends AbstractExtensionHandler {
    private static final String WIKI_NAMESPACEPREFIX = "wiki:";
    private static final String PROPERTY_USERREFERENCE = "user.reference";
    @Inject
    private Packager packager;
    @Inject
    @Named(value="xar")
    private InstalledExtensionRepository xarRepository;
    @Inject
    private ComponentManager componentManager;

    public void install(LocalExtension localExtension, String namespace, Request request) throws InstallException {
        if (!request.isRemote()) {
            String wiki = namespace;
            if (wiki != null) {
                if (wiki.startsWith(WIKI_NAMESPACEPREFIX)) {
                    wiki = wiki.substring(WIKI_NAMESPACEPREFIX.length());
                } else {
                    throw new InstallException("Unsupported namespace [" + namespace + "], only " + WIKI_NAMESPACEPREFIX + "wikiid format is supported");
                }
            }
            this.install(null, localExtension, wiki, request);
        }
    }

    public void upgrade(LocalExtension previousLocalExtension, LocalExtension newLocalExtension, String namespace, Request request) throws InstallException {
        if (!request.isRemote()) {
            List<XarEntry> newPages;
            XarInstalledExtension previousXarExtension;
            String wiki = namespace;
            if (wiki != null) {
                if (wiki.startsWith(WIKI_NAMESPACEPREFIX)) {
                    wiki = wiki.substring(WIKI_NAMESPACEPREFIX.length());
                } else {
                    throw new InstallException("Unsupported namespace [" + namespace + "], only " + WIKI_NAMESPACEPREFIX + "wikiid format is supported");
                }
            }
            try {
                previousXarExtension = (XarInstalledExtension)this.xarRepository.resolve(previousLocalExtension.getId());
            }
            catch (ResolveException e) {
                throw new InstallException("Failed to get xar extension [" + previousLocalExtension.getId() + "] from xar repository", (Throwable)e);
            }
            this.install(previousXarExtension, newLocalExtension, wiki, request);
            HashSet<XarEntry> previousPages = new HashSet<XarEntry>(previousXarExtension.getPages());
            try {
                XarInstalledExtension newXarExtension = (XarInstalledExtension)this.xarRepository.resolve(newLocalExtension.getId());
                newPages = newXarExtension.getPages();
            }
            catch (ResolveException e) {
                try {
                    newPages = this.packager.getEntries(new File(newLocalExtension.getFile().getAbsolutePath()));
                }
                catch (IOException e1) {
                    throw new InstallException("Failed to get xar extension [" + newLocalExtension.getId() + "] pages", (Throwable)e);
                }
            }
            for (XarEntry entry : newPages) {
                previousPages.remove(entry);
            }
            try {
                this.packager.unimportPages(previousPages, this.createPackageConfiguration(request, wiki));
            }
            catch (Exception e) {
                this.logger.warn("Exception when cleaning pages removed since previous xar extension version", (Throwable)e);
            }
        }
    }

    private void install(XarInstalledExtension previousExtension, LocalExtension localExtension, String wiki, Request request) throws InstallException {
        try {
            this.packager.importXAR(previousExtension != null ? new XarFile(new File(previousExtension.getFile().getAbsolutePath()), previousExtension.getPages()) : null, new File(localExtension.getFile().getAbsolutePath()), this.createPackageConfiguration(request, wiki));
        }
        catch (Exception e) {
            throw new InstallException("Failed to import xar for extension [" + localExtension + "]", (Throwable)e);
        }
    }

    public void uninstall(LocalExtension localExtension, String namespace, Request request) throws UninstallException {
        if (!request.isRemote()) {
            String wiki = namespace;
            if (wiki != null) {
                if (wiki.startsWith(WIKI_NAMESPACEPREFIX)) {
                    wiki = wiki.substring(WIKI_NAMESPACEPREFIX.length());
                } else {
                    throw new UninstallException("Unsupported namespace [" + namespace + "], only " + WIKI_NAMESPACEPREFIX + "wikiid format is supported");
                }
            }
            try {
                XarInstalledExtension xarLocalExtension = (XarInstalledExtension)this.xarRepository.resolve(localExtension.getId());
                List<XarEntry> pages = xarLocalExtension.getPages();
                this.packager.unimportPages(pages, this.createPackageConfiguration(request, wiki));
            }
            catch (Exception e) {
                throw new UninstallException("Failed to get xar extension [" + localExtension.getId() + "] from xar repository", (Throwable)e);
            }
        }
    }

    private PackageConfiguration createPackageConfiguration(Request request, String wiki) {
        DefaultPackageConfiguration configuration = new DefaultPackageConfiguration();
        MergeConfiguration mergeConfiguration = new MergeConfiguration();
        configuration.setMergeConfiguration(mergeConfiguration);
        configuration.setInteractive(request.isInteractive());
        configuration.setUser((DocumentReference)request.getProperty(PROPERTY_USERREFERENCE));
        configuration.setWiki(wiki);
        try {
            Job currentJob = ((JobContext)this.componentManager.getInstance(JobContext.class)).getCurrentJob();
            if (currentJob != null) {
                configuration.setJobStatus(currentJob.getStatus());
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to lookup JobContext, it will be impossible to do interactive install");
        }
        return configuration;
    }
}

