/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.handler.packager;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.event.XARImportedEvent;
import com.xpn.xwiki.internal.event.XARImportingEvent;
import com.xpn.xwiki.util.XWikiStubContextProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.slf4j.Logger;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.extension.xar.internal.handler.packager.NotADocumentException;
import org.xwiki.extension.xar.internal.handler.packager.PackageConfiguration;
import org.xwiki.extension.xar.internal.handler.packager.Packager;
import org.xwiki.extension.xar.internal.handler.packager.XarEntry;
import org.xwiki.extension.xar.internal.handler.packager.XarFile;
import org.xwiki.extension.xar.internal.handler.packager.XarMergeResult;
import org.xwiki.extension.xar.internal.handler.packager.xml.DocumentImporterHandler;
import org.xwiki.extension.xar.internal.handler.packager.xml.RootHandler;
import org.xwiki.extension.xar.internal.handler.packager.xml.UnknownRootElement;
import org.xwiki.extension.xar.internal.handler.packager.xml.XarPageLimitedHandler;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

@Component
@Singleton
public class DefaultPackager
implements Packager,
Initializable {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Execution execution;
    @Inject
    @Named(value="explicit")
    private DocumentReferenceResolver<EntityReference> resolver;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private Logger logger;
    @Inject
    private ObservationManager observation;
    @Inject
    private XWikiStubContextProvider contextProvider;
    private SAXParserFactory parserFactory;

    public void initialize() throws InitializationException {
        this.parserFactory = SAXParserFactory.newInstance();
    }

    @Override
    public void importXAR(XarFile previousXarFile, File xarFile, PackageConfiguration configuration) throws IOException, XWikiException {
        if (configuration.getWiki() == null) {
            XWikiContext context = this.getXWikiContext();
            if (context.getWiki().isVirtualMode()) {
                List wikis = this.getXWikiContext().getWiki().getVirtualWikisDatabaseNames(context);
                if (!wikis.contains(context.getMainXWiki())) {
                    this.importXARToWiki(previousXarFile, xarFile, context.getMainXWiki(), configuration);
                }
                for (String subwiki : wikis) {
                    this.importXARToWiki(previousXarFile, xarFile, subwiki, configuration);
                }
            } else {
                this.importXARToWiki(previousXarFile, xarFile, context.getMainXWiki(), configuration);
            }
        } else {
            this.importXARToWiki(previousXarFile, xarFile, configuration.getWiki(), configuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XarMergeResult importXARToWiki(XarFile previousXarFile, File xarFile, String wiki, PackageConfiguration configuration) throws IOException {
        FileInputStream fis = new FileInputStream(xarFile);
        try {
            XarMergeResult xarMergeResult = this.importXARToWiki(previousXarFile, fis, wiki, configuration);
            return xarMergeResult;
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XarMergeResult importXARToWiki(XarFile previousXarFile, InputStream xarInputStream, String wiki, PackageConfiguration configuration) throws IOException {
        XarMergeResult mergeResult = new XarMergeResult();
        ZipArchiveInputStream zis = new ZipArchiveInputStream(xarInputStream);
        XWikiContext xcontext = this.getXWikiContext();
        String currentWiki = xcontext.getDatabase();
        try {
            xcontext.setDatabase(wiki);
            this.observation.notify((Event)new XARImportingEvent(), null, (Object)xcontext);
            ArchiveEntry entry = zis.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    try {
                        DocumentImporterHandler documentHandler = new DocumentImporterHandler(this, this.componentManager, wiki);
                        documentHandler.setPreviousXarFile(previousXarFile);
                        documentHandler.setConfiguration(configuration);
                        this.parseDocument((InputStream)zis, documentHandler);
                        if (documentHandler.getMergeResult() != null) {
                            mergeResult.addMergeResult(documentHandler.getMergeResult());
                        }
                    }
                    catch (NotADocumentException e) {
                        this.logger.debug("Entry [{}] is not a document", (Object)entry.getName(), (Object)e);
                    }
                    catch (Exception e) {
                        this.logger.error("Failed to parse document [{}]", (Object)entry.getName(), (Object)e);
                    }
                }
                entry = zis.getNextEntry();
            }
        }
        finally {
            this.observation.notify((Event)new XARImportedEvent(), null, (Object)xcontext);
            xcontext.setDatabase(currentWiki);
        }
        return mergeResult;
    }

    @Override
    public void unimportXAR(File xarFile, PackageConfiguration configuration) throws IOException, XWikiException {
        if (configuration.getWiki() == null) {
            XWikiContext context = this.getXWikiContext();
            if (context.getWiki().isVirtualMode()) {
                List wikis = this.getXWikiContext().getWiki().getVirtualWikisDatabaseNames(context);
                if (!wikis.contains(context.getMainXWiki())) {
                    this.unimportXARFromWiki(xarFile, context.getMainXWiki(), configuration);
                }
                for (String subwiki : wikis) {
                    this.unimportXARFromWiki(xarFile, subwiki, configuration);
                }
            } else {
                this.unimportXARFromWiki(xarFile, context.getMainXWiki(), configuration);
            }
        } else {
            this.unimportXARFromWiki(xarFile, configuration.getWiki(), configuration);
        }
    }

    private void unimportXARFromWiki(File xarFile, String wiki, PackageConfiguration configuration) throws IOException {
        this.unimportPagesFromWiki(this.getEntries(xarFile), wiki, configuration);
    }

    @Override
    public void unimportPages(Collection<XarEntry> pages, PackageConfiguration configuration) throws XWikiException {
        if (configuration.getWiki() == null) {
            XWikiContext context = this.getXWikiContext();
            if (context.getWiki().isVirtualMode()) {
                List wikis = this.getXWikiContext().getWiki().getVirtualWikisDatabaseNames(context);
                if (!wikis.contains(context.getMainXWiki())) {
                    this.unimportPagesFromWiki(pages, context.getMainXWiki(), configuration);
                }
                for (String subwiki : wikis) {
                    this.unimportPagesFromWiki(pages, subwiki, configuration);
                }
            } else {
                this.unimportPagesFromWiki(pages, context.getMainXWiki(), configuration);
            }
        } else {
            this.unimportPagesFromWiki(pages, configuration.getWiki(), configuration);
        }
    }

    private void unimportPagesFromWiki(Collection<XarEntry> pages, String wiki, PackageConfiguration configuration) {
        WikiReference wikiReference = new WikiReference(wiki);
        XWikiContext xcontext = this.getXWikiContext();
        for (XarEntry xarEntry : pages) {
            DocumentReference documentReference = this.resolver.resolve((Object)xarEntry.getDocumentReference(), new Object[]{wikiReference});
            try {
                XWikiDocument document = this.getXWikiContext().getWiki().getDocument(documentReference, xcontext);
                if (document.isNew()) continue;
                String language = xarEntry.getLanguage();
                if (language != null) {
                    document = document.getTranslatedDocument(language, xcontext);
                    this.getXWikiContext().getWiki().deleteDocument(document, xcontext);
                    continue;
                }
                this.getXWikiContext().getWiki().deleteAllDocuments(document, xcontext);
            }
            catch (XWikiException e) {
                this.logger.error("Failed to delete document [{}]", this.serializer.serialize((EntityReference)documentReference, new Object[0]), (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<XarEntry> getEntries(File xarFile) throws IOException {
        List<XarEntry> documents = null;
        FileInputStream fis = new FileInputStream(xarFile);
        ZipArchiveInputStream zis = new ZipArchiveInputStream((InputStream)fis);
        try {
            ZipArchiveEntry zipEntry = zis.getNextZipEntry();
            while (zipEntry != null) {
                if (!zipEntry.isDirectory()) {
                    try {
                        XarPageLimitedHandler documentHandler = new XarPageLimitedHandler(this.componentManager);
                        this.parseDocument((InputStream)zis, documentHandler);
                        if (documents == null) {
                            documents = new ArrayList<XarEntry>();
                        }
                        XarEntry xarEntry = documentHandler.getXarEntry();
                        xarEntry.setEntryName(zipEntry.getName());
                        documents.add(xarEntry);
                    }
                    catch (NotADocumentException e) {
                    }
                    catch (Exception e) {
                        this.logger.error("Failed to parse document [{}]", (Object)zipEntry.getName(), (Object)e);
                    }
                }
                zipEntry = zis.getNextZipEntry();
            }
        }
        finally {
            zis.close();
        }
        return documents != null ? documents : Collections.emptyList();
    }

    public void parseDocument(InputStream in, ContentHandler documentHandler) throws ParserConfigurationException, SAXException, IOException, NotADocumentException {
        SAXParser saxParser = this.parserFactory.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        RootHandler handler = new RootHandler(this.componentManager);
        handler.setHandler("xwikidoc", documentHandler);
        xmlReader.setContentHandler(handler);
        try {
            xmlReader.parse(new InputSource((InputStream)new CloseShieldInputStream(in)));
        }
        catch (UnknownRootElement e) {
            throw new NotADocumentException("Failed to parse stream", e);
        }
    }

    private ExecutionContext getExecutionContext() {
        return this.execution.getContext();
    }

    private XWikiContext getXWikiContext() {
        XWikiContext context = (XWikiContext)this.getExecutionContext().getProperty("xwikicontext");
        if (context == null) {
            context = this.contextProvider.createStubContext();
            this.getExecutionContext().setProperty("xwikicontext", (Object)context);
        }
        return context;
    }
}

