/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.handler.packager.xml;

import com.xpn.xwiki.XWikiContext;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;

public class AbstractHandler
extends DefaultHandler {
    @Inject
    private ComponentManager componentManager;
    private Object currentBean;
    private ContentHandler currentHandler;
    private int currentHandlerLevel;
    private int depth = 0;
    protected StringBuffer value;
    protected Set<String> skippedElements = new HashSet<String>();
    protected Set<String> supportedElements;

    public AbstractHandler(ComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    public AbstractHandler(ComponentManager componentManager, Object currentBean) {
        this(componentManager);
        this.currentBean = currentBean;
    }

    protected ComponentManager getComponentManager() {
        return this.componentManager;
    }

    protected Object getCurrentBean() {
        return this.currentBean;
    }

    protected void setCurrentBean(Object currentBean) {
        this.currentBean = currentBean;
    }

    protected void addsupportedElements(String supportedElement) {
        if (this.supportedElements == null) {
            this.supportedElements = new HashSet<String>();
        }
        this.supportedElements.add(supportedElement);
    }

    public boolean isSupported(String elementName) {
        return !this.skippedElements.contains(elementName) && (this.supportedElements == null || this.supportedElements.contains(elementName));
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.currentHandler == null) {
            if (this.depth == 0) {
                this.startHandlerElement(uri, localName, qName, attributes);
            } else if (this.depth == 1) {
                this.startElementInternal(uri, localName, qName, attributes);
            }
        }
        if (this.currentHandler != null) {
            this.currentHandler.startElement(uri, localName, qName, attributes);
        }
        ++this.depth;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentHandler != null) {
            this.currentHandler.characters(ch, start, length);
        } else if (this.depth == 2) {
            this.charactersInternal(ch, start, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        --this.depth;
        try {
            if (this.currentHandler != null) {
                this.currentHandler.endElement(uri, localName, qName);
                if (this.depth == this.currentHandlerLevel) {
                    this.endElementInternal(uri, localName, qName);
                    this.currentHandler = null;
                }
            } else if (this.depth == 0) {
                this.endHandlerElement(uri, localName, qName);
            } else if (this.depth == 1) {
                this.endElementInternal(uri, localName, qName);
            }
        }
        finally {
            this.value = null;
        }
    }

    protected void startElementInternal(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.isSupported(qName)) {
            if (this.value == null) {
                this.value = new StringBuffer();
            } else {
                this.value.setLength(0);
            }
        }
    }

    protected void charactersInternal(char[] ch, int start, int length) throws SAXException {
        if (this.currentBean != null && this.value != null) {
            this.value.append(ch, start, length);
        }
    }

    protected void endElementInternal(String uri, String localName, String qName) throws SAXException {
        if (this.currentBean != null && this.value != null) {
            try {
                Method setter = this.currentBean.getClass().getMethod("set" + StringUtils.capitalize((String)qName), String.class);
                setter.invoke(this.currentBean, this.value.toString());
                this.currentBeanModified();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected void currentBeanModified() {
    }

    protected void startHandlerElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
    }

    protected void endHandlerElement(String uri, String localName, String qName) throws SAXException {
    }

    protected void setCurrentHandler(ContentHandler currentHandler) {
        this.currentHandler = currentHandler;
        this.currentHandlerLevel = this.depth;
    }

    public ContentHandler getCurrentHandler() {
        return this.currentHandler;
    }

    protected ExecutionContext getExecutionContext() throws ComponentLookupException {
        return ((Execution)this.getComponentManager().getInstance(Execution.class)).getContext();
    }

    protected XWikiContext getXWikiContext() throws ComponentLookupException {
        return (XWikiContext)this.getExecutionContext().getProperty("xwikicontext");
    }
}

