/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.handler;

import com.xpn.xwiki.XWikiContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.event.WikiCopiedEvent;
import org.xwiki.bridge.event.WikiCreatedEvent;
import org.xwiki.bridge.event.WikiDeletedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.handler.ExtensionHandler;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.job.Request;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Component
@Singleton
@Named(value="extension.xar.WikiCopiedListener")
public class WikiEventListener
implements EventListener {
    private static final List<Event> EVENTS = Arrays.asList(new WikiCopiedEvent(), new WikiCreatedEvent(), new WikiDeletedEvent());
    @Inject
    private Provider<InstalledExtensionRepository> installedRepositoryProvider;
    @Inject
    @Named(value="xar")
    private Provider<ExtensionHandler> xarHandlerProvider;
    @Inject
    private Execution execution;
    @Inject
    private Logger logger;

    public String getName() {
        return "extension.xar.WikiCopiedListener";
    }

    public List<Event> getEvents() {
        return EVENTS;
    }

    public void onEvent(Event event, Object o, Object context) {
        if (event instanceof WikiCopiedEvent) {
            this.onWikiCopied((WikiCopiedEvent)event);
        } else if (event instanceof WikiCreatedEvent) {
            this.onWikiCreated((WikiCreatedEvent)event, (XWikiContext)context);
        } else if (event instanceof WikiDeletedEvent) {
            this.onWikiDeleted((WikiDeletedEvent)event);
        }
    }

    private void onWikiCopied(WikiCopiedEvent event) {
        String sourceNamespace = "wiki:" + event.getSourceWikiId();
        String targetNamespace = "wiki:" + event.getTargetWikiId();
        InstalledExtensionRepository installedRepository = (InstalledExtensionRepository)this.installedRepositoryProvider.get();
        Collection installedExtensions = installedRepository.getInstalledExtensions(sourceNamespace);
        for (InstalledExtension installedExtension : installedExtensions) {
            if (installedExtension.isInstalled(null)) continue;
            try {
                installedRepository.installExtension((LocalExtension)installedExtension, targetNamespace, installedExtension.isDependency(sourceNamespace));
            }
            catch (InstallException e) {
                this.logger.error("Failed to copy install state for extension [{}] from namespace [{}] to namespace [{}]", new Object[]{installedExtension, sourceNamespace, targetNamespace, e});
            }
        }
    }

    private void onWikiDeleted(WikiDeletedEvent event) {
        String namespace = "wiki:" + event.getWikiId();
        InstalledExtensionRepository installedRepository = (InstalledExtensionRepository)this.installedRepositoryProvider.get();
        Collection installedExtensions = installedRepository.getInstalledExtensions(namespace);
        for (InstalledExtension installedExtension : installedExtensions) {
            if (installedExtension.isInstalled(null)) continue;
            try {
                installedRepository.uninstallExtension(installedExtension, namespace);
            }
            catch (UninstallException e) {
                this.logger.error("Failed to uninstall extension [{}] from namespace [{}]", new Object[]{installedExtension, namespace, e});
            }
        }
    }

    private void onWikiCreated(WikiCreatedEvent event, XWikiContext context) {
        String namespace = "wiki:" + event.getWikiId();
        InstalledExtensionRepository installedRepository = (InstalledExtensionRepository)this.installedRepositoryProvider.get();
        Collection installedExtensions = installedRepository.getInstalledExtensions(null);
        ExtensionHandler xarHandler = (ExtensionHandler)this.xarHandlerProvider.get();
        InstallRequest installRequest = new InstallRequest();
        installRequest.setProperty("user.reference", (Object)context.getUserReference());
        installRequest.setInteractive(false);
        for (InstalledExtension installedExtension : installedExtensions) {
            installRequest.addExtension(installedExtension.getId());
            try {
                xarHandler.install((LocalExtension)installedExtension, namespace, (Request)installRequest);
            }
            catch (InstallException e) {
                this.logger.error("Failed to import extension [{}] in wiki [{}]", new Object[]{installedExtension, event.getWikiId(), e});
            }
        }
    }
}

