/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.job.diff;

import java.util.LinkedHashMap;
import java.util.List;
import org.xwiki.diff.Delta;
import org.xwiki.diff.display.UnifiedDiffBlock;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.stability.Unstable;

@Unstable
public class EntityUnifiedDiff<T extends EntityReference>
extends LinkedHashMap<String, List<UnifiedDiffBlock<String, Character>>> {
    private static final long serialVersionUID = 1L;
    private final T previousReference;
    private final T nextReference;

    public EntityUnifiedDiff(T previousReference, T nextReference) {
        this.previousReference = previousReference;
        this.nextReference = nextReference;
    }

    public T getPreviousReference() {
        return this.previousReference;
    }

    public T getNextReference() {
        return this.nextReference;
    }

    public T getReference() {
        return this.previousReference == null ? this.nextReference : this.previousReference;
    }

    public Delta.Type getType() {
        if (this.previousReference == null) {
            return Delta.Type.INSERT;
        }
        if (this.nextReference == null) {
            return Delta.Type.DELETE;
        }
        return Delta.Type.CHANGE;
    }
}

