/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.script.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.extension.CoreExtension;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionManager;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.internal.VersionManager;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.job.Job;
import org.xwiki.extension.job.JobException;
import org.xwiki.extension.job.JobManager;
import org.xwiki.extension.job.JobStatus;
import org.xwiki.extension.job.UninstallRequest;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.extension.wrap.WrappingCoreExtension;
import org.xwiki.extension.wrap.WrappingExtension;
import org.xwiki.extension.wrap.WrappingJobStatus;
import org.xwiki.extension.wrap.WrappingLocalExtension;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="extension")
@Singleton
public class ExtensionManagerScriptService
implements ScriptService {
    private static final String EXTENSIONERROR_KEY = "extensionerror";
    @Inject
    private ExtensionManager extensionManager;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private VersionManager versionManager;
    @Inject
    private LocalExtensionRepository localExtensionRepository;
    @Inject
    private CoreExtensionRepository coreExtensionRepository;
    @Inject
    private ExtensionRepositoryManager reporitoryManager;
    @Inject
    private JobManager taskManager;
    @Inject
    private Execution execution;

    private <K> Map<K, Collection<LocalExtension>> wrapExtensions(Map<K, Collection<LocalExtension>> extensions) {
        LinkedHashMap wrappedExtensions = new LinkedHashMap();
        for (Map.Entry<K, Collection<LocalExtension>> entry : extensions.entrySet()) {
            wrappedExtensions.put(entry.getKey(), this.wrapExtensions(entry.getValue()));
        }
        return wrappedExtensions;
    }

    private <T extends Extension> Collection<T> wrapExtensions(Collection<? extends Extension> extensions) {
        ArrayList<T> wrappedExtensions = new ArrayList<T>(extensions.size());
        for (Extension extension : extensions) {
            wrappedExtensions.add(this.wrapExtension(extension));
        }
        return wrappedExtensions;
    }

    private <T extends Extension> T wrapExtension(Extension extension) {
        Object wrappedExtension = extension instanceof CoreExtension ? new WrappingCoreExtension((CoreExtension)extension) : (extension instanceof LocalExtension ? new WrappingLocalExtension((LocalExtension)extension) : (extension != null ? new WrappingExtension(extension) : null));
        return (T)wrappedExtension;
    }

    public Exception getLastError() {
        return (Exception)this.execution.getContext().getProperty(EXTENSIONERROR_KEY);
    }

    private void setError(Exception e) {
        this.execution.getContext().setProperty(EXTENSIONERROR_KEY, (Object)e);
    }

    public Extension resolve(String id, String version) {
        Extension extension;
        this.setError(null);
        try {
            extension = (Extension)this.wrapExtension(this.extensionManager.resolveExtension(new ExtensionId(id, version)));
        }
        catch (Exception e) {
            this.setError(e);
            extension = null;
        }
        return extension;
    }

    public Collection<Extension> search(String pattern, int offset, int nb) {
        return this.wrapExtensions(this.reporitoryManager.search(pattern, offset, nb));
    }

    public Map<String, Collection<LocalExtension>> getBackwardDependencies(String id, String version) {
        Map extensions;
        this.setError(null);
        try {
            extensions = this.wrapExtensions(this.localExtensionRepository.getBackwardDependencies(new ExtensionId(id, version)));
        }
        catch (Exception e) {
            this.setError(e);
            extensions = null;
        }
        return extensions;
    }

    public LocalExtension getInstalledExtension(String id, String namespace) {
        return (LocalExtension)this.wrapExtension((Extension)this.localExtensionRepository.getInstalledExtension(id, namespace));
    }

    public Collection<LocalExtension> getInstalledExtensions(String namespace) {
        return this.wrapExtensions(this.localExtensionRepository.getInstalledExtensions(namespace));
    }

    public Collection<LocalExtension> getInstalledExtensions() {
        return this.wrapExtensions(this.localExtensionRepository.getInstalledExtensions());
    }

    public Collection<CoreExtension> getCoreExtensions() {
        return this.wrapExtensions(this.coreExtensionRepository.getCoreExtensions());
    }

    public Collection<LocalExtension> getLocalExtensions() {
        return this.wrapExtensions(this.localExtensionRepository.getLocalExtensions());
    }

    public CoreExtension getCoreExtension(String id) {
        return (CoreExtension)this.wrapExtension((Extension)this.coreExtensionRepository.getCoreExtension(id));
    }

    public VersionManager getVersionManager() {
        return this.versionManager;
    }

    public Job getCurrentJob() {
        if (!this.documentAccessBridge.hasProgrammingRights()) {
            this.setError((Exception)new JobException("Need programming right to get current task"));
            return null;
        }
        return this.taskManager.getCurrentJob();
    }

    public JobStatus getCurrentJobStatus() {
        JobStatus jobStatus;
        Job job = this.taskManager.getCurrentJob();
        if (job != null) {
            jobStatus = job.getStatus();
            if (!this.documentAccessBridge.hasProgrammingRights()) {
                jobStatus = new WrappingJobStatus(jobStatus);
            }
        } else {
            jobStatus = null;
        }
        return jobStatus;
    }

    public Job install(String id, String version, String wiki) {
        Job task;
        if (!this.documentAccessBridge.hasProgrammingRights()) {
            this.setError((Exception)((Object)new JobException("Need programming right to install an extension")));
            return null;
        }
        this.setError(null);
        InstallRequest installRequest = new InstallRequest();
        installRequest.addExtension(new ExtensionId(id, version));
        if (wiki != null) {
            installRequest.addNamespace(wiki);
        }
        try {
            task = this.taskManager.install(installRequest);
        }
        catch (JobException e) {
            this.setError((Exception)((Object)e));
            task = null;
        }
        return task;
    }

    public Job uninstall(String id, String version) {
        Job task;
        if (!this.documentAccessBridge.hasProgrammingRights()) {
            this.setError((Exception)((Object)new JobException("Need programming right to uninstall an extension")));
            return null;
        }
        this.setError(null);
        UninstallRequest uninstallRequest = new UninstallRequest();
        uninstallRequest.addExtension(new ExtensionId(id, version));
        try {
            task = this.taskManager.uninstall(uninstallRequest);
        }
        catch (Exception e) {
            this.setError(e);
            task = null;
        }
        return task;
    }
}

