/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.script;

import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.script.AbstractExtensionScriptService;

@Component
@Named(value="extension.installed")
@Singleton
public class InstalledExtensionScriptService
extends AbstractExtensionScriptService {
    public static final String ID = "installed";
    @Inject
    private InstalledExtensionRepository installedExtensionRepository;

    public InstalledExtensionRepository getRepository() {
        return this.safe(this.installedExtensionRepository);
    }

    public Collection<InstalledExtension> getInstalledExtensions() {
        return this.safe(this.installedExtensionRepository.getInstalledExtensions());
    }

    public Collection<InstalledExtension> getInstalledExtensions(String namespace) {
        return this.safe(this.installedExtensionRepository.getInstalledExtensions(namespace));
    }

    public InstalledExtension getInstalledExtension(String feature, String namespace) {
        return this.safe(this.installedExtensionRepository.getInstalledExtension(feature, namespace));
    }

    public Map<String, Collection<InstalledExtension>> getBackwardDependencies(String feature) {
        InstalledExtension installedExtension = this.installedExtensionRepository.getInstalledExtension(feature, null);
        Map<String, Collection<InstalledExtension>> extensions = installedExtension != null ? this.getBackwardDependencies(installedExtension.getId()) : null;
        return extensions;
    }

    public Map<String, Collection<InstalledExtension>> getBackwardDependencies(ExtensionId extensionId) {
        this.setError(null);
        try {
            return this.safe(this.installedExtensionRepository.getBackwardDependencies(extensionId));
        }
        catch (Exception e) {
            this.setError(e);
            Map<String, Collection<InstalledExtension>> extensions = null;
            return extensions;
        }
    }

    public Collection<InstalledExtension> getBackwardDependencies(String feature, String namespace) {
        this.setError(null);
        try {
            return this.safe(this.installedExtensionRepository.getBackwardDependencies(feature, namespace));
        }
        catch (Exception e) {
            this.setError(e);
            Collection<InstalledExtension> extensions = null;
            return extensions;
        }
    }
}

