/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.script.internal;

import com.xpn.xwiki.XWikiException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.Extension;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.handler.ExtensionValidator;
import org.xwiki.job.Request;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Singleton
public class XWikiExtensionValidator
implements ExtensionValidator {
    private static final String PROPERTY_USERREFERENCE = "user.reference";
    private static final String PROPERTY_CALLERREFERENCE = "caller.reference";
    private static final String PROPERTY_CHECKRIGHTS = "checkrights";
    @Inject
    private AuthorizationManager authorization;

    private boolean hasProgramming(Request request) throws XWikiException {
        DocumentReference user;
        boolean hasAccess = true;
        if (request.getProperty(PROPERTY_CALLERREFERENCE) != null) {
            hasAccess = this.authorization.hasAccess(Right.PROGRAM, this.getRequestUserReference(PROPERTY_CALLERREFERENCE, request), null);
        }
        if (hasAccess && (user = this.getRequestUserReference(PROPERTY_USERREFERENCE, request)) != null) {
            hasAccess = this.authorization.hasAccess(Right.PROGRAM, user, null);
        }
        return hasAccess;
    }

    private DocumentReference getRequestUserReference(String property, Request request) {
        Object obj = request.getProperty(property);
        if (obj instanceof DocumentReference) {
            return (DocumentReference)obj;
        }
        return null;
    }

    public void checkInstall(Extension extension, String namespace, Request request) throws InstallException {
        if (request.getProperty(PROPERTY_CHECKRIGHTS) == Boolean.TRUE) {
            try {
                if (!this.hasProgramming(request)) {
                    if (namespace == null) {
                        throw new InstallException(String.format("Programming right is required to install extension [%s]", extension.getId()));
                    }
                    throw new InstallException(String.format("Programming right is required to install extension [%s] on namespace [%s]", extension.getId(), namespace));
                }
            }
            catch (XWikiException e) {
                throw new InstallException("Failed to check rights to install extension", (Throwable)e);
            }
        }
    }

    public void checkUninstall(InstalledExtension extension, String namespace, Request request) throws UninstallException {
        if (request.getProperty(PROPERTY_CHECKRIGHTS) == Boolean.TRUE) {
            try {
                if (!this.hasProgramming(request)) {
                    if (namespace == null) {
                        throw new UninstallException(String.format("Programming right is required to uninstall extension [%s]", extension.getId()));
                    }
                    throw new UninstallException(String.format("Programming right is required to uninstall extension [%s] from namespace [%s]", extension.getId(), namespace));
                }
            }
            catch (XWikiException e) {
                throw new UninstallException("Failed to check rights to uninstall extension", (Throwable)e);
            }
        }
    }
}

