/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.script;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.namespace.NamespaceValidator;
import org.xwiki.extension.CoreExtension;
import org.xwiki.extension.DefaultExtensionDependency;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionManager;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.job.UninstallRequest;
import org.xwiki.extension.job.internal.AbstractExtensionJob;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.repository.search.ExtensionQuery;
import org.xwiki.extension.script.AbstractExtensionScriptService;
import org.xwiki.extension.script.CoreExtensionScriptService;
import org.xwiki.extension.script.InstalledExtensionScriptService;
import org.xwiki.extension.script.LocalExtensionScriptService;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.VersionConstraint;
import org.xwiki.extension.version.VersionRange;
import org.xwiki.extension.version.internal.DefaultVersion;
import org.xwiki.extension.version.internal.DefaultVersionConstraint;
import org.xwiki.extension.version.internal.DefaultVersionRange;
import org.xwiki.job.Job;
import org.xwiki.job.JobException;
import org.xwiki.job.JobGroupPath;
import org.xwiki.job.Request;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.script.service.ScriptService;
import org.xwiki.script.service.ScriptServiceManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="extension")
@Singleton
public class ExtensionManagerScriptService
extends AbstractExtensionScriptService {
    public static final String ROLEHINT = "extension";
    public static final String EXTENSION_JOBID_PREFIX = "extension";
    public static final String EXTENSIONACTION_JOBID_PREFIX = "action";
    public static final String EXTENSIONPLAN_JOBID_PREFIX = "plan";
    private static final String PROPERTY_JOB_TYPE = "job.type";
    @Inject
    private ExtensionManager extensionManager;
    @Inject
    private ExtensionRepositoryManager repositoryManager;
    @Inject
    private ScriptServiceManager scriptServiceManager;
    @Inject
    private NamespaceValidator namespaceResolver;

    public <S extends ScriptService> S get(String serviceName) {
        return (S)this.scriptServiceManager.get("extension." + serviceName);
    }

    public Collection<ExtensionRepository> getRepositories() {
        return this.safe(this.repositoryManager.getRepositories());
    }

    public ExtensionRepository getRepository(String repositoryId) {
        return this.safe(this.extensionManager.getRepository(repositoryId));
    }

    public IterableResult<Extension> search(String pattern, int offset, int nb) {
        return this.repositoryManager.search(pattern, offset, nb);
    }

    public IterableResult<Extension> search(ExtensionQuery query) {
        return this.repositoryManager.search(query);
    }

    public ExtensionQuery newQuery(String query) {
        return new ExtensionQuery(query);
    }

    public Extension resolve(String id, String version) {
        this.setError(null);
        Extension extension = null;
        try {
            extension = this.safe(this.extensionManager.resolveExtension(new ExtensionId(id, version)));
        }
        catch (Exception e) {
            this.setError(e);
        }
        return extension;
    }

    @Deprecated
    public Extension resolve(ExtensionDependency extensionDependency) {
        this.setError(null);
        Extension extension = null;
        try {
            extension = this.safe(this.extensionManager.resolveExtension(extensionDependency));
        }
        catch (Exception e) {
            this.setError(e);
        }
        return extension;
    }

    public Extension resolve(ExtensionDependency extensionDependency, String namespace) {
        this.setError(null);
        Extension extension = null;
        try {
            extension = this.safe(this.extensionManager.resolveExtension(extensionDependency, namespace));
        }
        catch (Exception e) {
            this.setError(e);
        }
        return extension;
    }

    public IterableResult<Version> resolveVersions(String id, int offset, int nb) {
        this.setError(null);
        IterableResult versions = null;
        try {
            versions = this.repositoryManager.resolveVersions(id, offset, nb);
        }
        catch (Exception e) {
            this.setError(e);
        }
        return versions;
    }

    private List<String> getJobId(String prefix, String extensionId, String namespace) {
        List<String> jobId = namespace != null ? Arrays.asList("extension", prefix, extensionId, namespace) : Arrays.asList("extension", prefix, extensionId);
        return jobId;
    }

    public InstallRequest createInstallRequest(String id, String version, String namespace) {
        InstallRequest installRequest = this.createInstallPlanRequest(id, version, namespace);
        installRequest.setId(this.getJobId(EXTENSIONACTION_JOBID_PREFIX, id, namespace));
        installRequest.setInteractive(true);
        installRequest.setProperty(PROPERTY_JOB_TYPE, (Object)"install");
        DocumentReference currentUserReference = this.documentAccessBridge.getCurrentUserReference();
        if (currentUserReference != null) {
            installRequest.setExtensionProperty("user.reference", (Object)currentUserReference.toString());
        }
        return installRequest;
    }

    public Job install(String id, String version, String namespace) {
        return this.install(this.createInstallRequest(id, version, namespace));
    }

    public Job install(InstallRequest installRequest) {
        this.setError(null);
        if (!this.authorization.hasAccess(Right.PROGRAM)) {
            this.setRightsProperties(installRequest);
        }
        Job job = null;
        try {
            job = this.jobExecutor.execute("install", (Request)installRequest);
        }
        catch (JobException e) {
            this.setError((Exception)((Object)e));
        }
        return job;
    }

    public InstallRequest createInstallPlanRequest(String id, String version, String namespace) {
        InstallRequest installRequest = new InstallRequest();
        installRequest.setId(this.getJobId(EXTENSIONPLAN_JOBID_PREFIX, id, namespace));
        installRequest.addExtension(new ExtensionId(id, version));
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            installRequest.addNamespace(namespace);
        }
        installRequest.setProperty("context.wiki", (Object)((XWikiContext)this.xcontextProvider.get()).getWikiId());
        installRequest.setProperty("context.action", (Object)((XWikiContext)this.xcontextProvider.get()).getAction());
        this.setRightsProperties(installRequest);
        installRequest.setProperty(PROPERTY_JOB_TYPE, (Object)"installplan");
        return installRequest;
    }

    public Job createInstallPlan(InstallRequest installRequest) {
        this.setError(null);
        if (!this.authorization.hasAccess(Right.PROGRAM)) {
            this.setRightsProperties(installRequest);
        }
        Job job = null;
        try {
            job = this.jobExecutor.execute("installplan", (Request)installRequest);
        }
        catch (JobException e) {
            this.setError((Exception)((Object)e));
        }
        return job;
    }

    public Job createInstallPlan(String id, String version, String namespace) {
        return this.createInstallPlan(this.createInstallPlanRequest(id, version, namespace));
    }

    public Job uninstall(String id, String namespace) {
        return this.uninstall(this.createUninstallRequest(id, namespace));
    }

    public Job uninstall(ExtensionId extensionId) {
        return this.uninstall(this.createUninstallRequest(extensionId, null));
    }

    public Job uninstall(UninstallRequest uninstallRequest) {
        this.setError(null);
        if (!this.authorization.hasAccess(Right.PROGRAM)) {
            this.setRightsProperties(uninstallRequest);
        }
        Job job = null;
        try {
            job = this.jobExecutor.execute("uninstall", (Request)uninstallRequest);
        }
        catch (JobException e) {
            this.setError((Exception)((Object)e));
        }
        return job;
    }

    public UninstallRequest createUninstallRequest(String id, String namespace) {
        return this.createUninstallRequest(new ExtensionId(id, (Version)null), namespace);
    }

    private UninstallRequest createUninstallRequest(ExtensionId extensionId, String namespace) {
        UninstallRequest uninstallRequest = this.createUninstallPlanRequest(extensionId, namespace);
        uninstallRequest.setId(this.getJobId(EXTENSIONACTION_JOBID_PREFIX, extensionId.getId(), namespace));
        uninstallRequest.setInteractive(true);
        uninstallRequest.setProperty(PROPERTY_JOB_TYPE, (Object)"uninstall");
        return uninstallRequest;
    }

    private UninstallRequest createUninstallPlanRequest(ExtensionId extensionId, String namespace) {
        UninstallRequest uninstallRequest = new UninstallRequest();
        uninstallRequest.setId(this.getJobId(EXTENSIONPLAN_JOBID_PREFIX, extensionId.getId(), namespace));
        uninstallRequest.addExtension(extensionId);
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            uninstallRequest.addNamespace(namespace);
        }
        uninstallRequest.setProperty("context.wiki", (Object)((XWikiContext)this.xcontextProvider.get()).getWikiId());
        uninstallRequest.setProperty("context.action", (Object)((XWikiContext)this.xcontextProvider.get()).getAction());
        this.setRightsProperties(uninstallRequest);
        uninstallRequest.setProperty(PROPERTY_JOB_TYPE, (Object)"uninstallplan");
        return uninstallRequest;
    }

    public Job createUninstallPlan(String id, String namespace) {
        return this.createUninstallPlan(this.createUninstallPlanRequest(new ExtensionId(id, (Version)null), namespace));
    }

    public Job createUninstallPlan(ExtensionId extensionId) {
        return this.createUninstallPlan(this.createUninstallPlanRequest(extensionId, null));
    }

    private Job createUninstallPlan(UninstallRequest uninstallRequest) {
        this.setError(null);
        if (!this.authorization.hasAccess(Right.PROGRAM)) {
            this.setRightsProperties(uninstallRequest);
        }
        Job job = null;
        try {
            job = this.jobExecutor.execute("uninstallplan", (Request)uninstallRequest);
        }
        catch (JobException e) {
            this.setError((Exception)((Object)e));
        }
        return job;
    }

    public InstallRequest createUpgradePlanRequest(String namespace) {
        InstallRequest installRequest = new InstallRequest();
        installRequest.setId(this.getJobId(EXTENSIONPLAN_JOBID_PREFIX, null, namespace));
        installRequest.addNamespace(namespace);
        installRequest.setProperty("context.wiki", (Object)((XWikiContext)this.xcontextProvider.get()).getWikiId());
        installRequest.setProperty("context.action", (Object)((XWikiContext)this.xcontextProvider.get()).getAction());
        return installRequest;
    }

    private InstallRequest createUpgradePlanRequest() {
        InstallRequest installRequest = new InstallRequest();
        installRequest.setId(this.getJobId(EXTENSIONPLAN_JOBID_PREFIX, null, null));
        installRequest.setProperty("context.wiki", (Object)((XWikiContext)this.xcontextProvider.get()).getWikiId());
        installRequest.setProperty("context.action", (Object)((XWikiContext)this.xcontextProvider.get()).getAction());
        return installRequest;
    }

    public Job createUpgradePlan(InstallRequest request) {
        request.setProperty("user.reference", (Object)this.documentAccessBridge.getCurrentUserReference());
        XWikiDocument callerDocument = this.getCallerDocument();
        if (callerDocument != null) {
            request.setProperty("caller.reference", (Object)callerDocument.getContentAuthorReference());
        }
        request.setProperty("checkrights", (Object)true);
        Job job = null;
        try {
            job = this.safe(this.jobExecutor.execute("upgradeplan", (Request)request));
        }
        catch (JobException e) {
            this.setError((Exception)((Object)e));
        }
        return job;
    }

    public Job createUpgradePlan(String namespace) {
        this.setError(null);
        return this.createUpgradePlan(this.createUpgradePlanRequest(namespace));
    }

    public Job createUpgradePlan() {
        this.setError(null);
        return this.createUpgradePlan(this.createUpgradePlanRequest());
    }

    public Job getCurrentJob() {
        this.setError(null);
        if (!this.authorization.hasAccess(Right.PROGRAM)) {
            this.setError((Exception)((Object)new JobException("You need programming rights to get the current job.")));
            return null;
        }
        return this.getCurrentJobInternal();
    }

    private Job getCurrentJobInternal() {
        String namespace = "wiki:" + ((XWikiContext)this.xcontextProvider.get()).getWikiId();
        Job job = this.jobExecutor.getCurrentJob(new JobGroupPath(namespace, AbstractExtensionJob.ROOT_GROUP));
        if (job == null) {
            job = this.jobExecutor.getCurrentJob(AbstractExtensionJob.ROOT_GROUP);
        }
        return job;
    }

    public JobStatus getExtensionJobStatus(String extensionId, String namespace) {
        return this.getJobStatus(this.getJobId(EXTENSIONACTION_JOBID_PREFIX, extensionId, namespace));
    }

    public JobStatus getExtensionPlanJobStatus(String extensionId, String namespace) {
        return this.getJobStatus(this.getJobId(EXTENSIONPLAN_JOBID_PREFIX, extensionId, namespace));
    }

    public JobStatus getCurrentJobStatus() {
        JobStatus jobStatus;
        Job job = this.getCurrentJobInternal();
        if (job != null) {
            jobStatus = job.getStatus();
            if (!this.authorization.hasAccess(Right.PROGRAM)) {
                jobStatus = this.safe(jobStatus);
            }
        } else {
            jobStatus = null;
        }
        return jobStatus;
    }

    public Version parseVersion(String version) {
        return new DefaultVersion(version);
    }

    public VersionRange parseVersionRange(String versionRange) {
        this.setError(null);
        try {
            return new DefaultVersionRange(versionRange);
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    public VersionConstraint parseVersionConstraint(String versionConstraint) {
        this.setError(null);
        try {
            return new DefaultVersionConstraint(versionConstraint);
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    public ExtensionDependency createExtensionDependency(String id, String versionConstraint) {
        this.setError(null);
        try {
            return new DefaultExtensionDependency(id, (VersionConstraint)new DefaultVersionConstraint(versionConstraint));
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    public boolean isAllowed(Collection<String> allowedNamespaces, String namespace) {
        return this.namespaceResolver.isAllowed(allowedNamespaces, namespace);
    }

    public boolean isAllowed(Extension extension, String namespace) {
        return this.namespaceResolver.isAllowed(extension.getAllowedNamespaces(), namespace);
    }

    @Deprecated
    public Collection<InstalledExtension> getInstalledExtensions() {
        return ((InstalledExtensionScriptService)this.get("installed")).getInstalledExtensions();
    }

    @Deprecated
    public Collection<InstalledExtension> getInstalledExtensions(String namespace) {
        return ((InstalledExtensionScriptService)this.get("installed")).getInstalledExtensions(namespace);
    }

    @Deprecated
    public InstalledExtension getInstalledExtension(String feature, String namespace) {
        return ((InstalledExtensionScriptService)this.get("installed")).getInstalledExtension(feature, namespace);
    }

    @Deprecated
    public Map<String, Collection<InstalledExtension>> getBackwardDependencies(String feature, String version) {
        return ((InstalledExtensionScriptService)this.get("installed")).getBackwardDependencies(feature);
    }

    @Deprecated
    public Collection<CoreExtension> getCoreExtensions() {
        return ((CoreExtensionScriptService)this.get("core")).getCoreExtensions();
    }

    @Deprecated
    public CoreExtension getCoreExtension(String feature) {
        return ((CoreExtensionScriptService)this.get("core")).getCoreExtension(feature);
    }

    @Deprecated
    public Collection<LocalExtension> getLocalExtensions() {
        return ((LocalExtensionScriptService)this.get("local")).getLocalExtensions();
    }
}

