/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.script.internal.safe;

import java.util.Collection;
import java.util.Map;
import org.xwiki.context.Execution;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepositoryException;
import org.xwiki.extension.script.internal.safe.SafeAdvancedSearchableExtensionRepository;
import org.xwiki.script.internal.safe.ScriptSafeProvider;

public class SafeLocalExtensionRepository<T extends LocalExtensionRepository>
extends SafeAdvancedSearchableExtensionRepository<T>
implements LocalExtensionRepository {
    public SafeLocalExtensionRepository(T repository, ScriptSafeProvider<?> safeProvider, Execution execution, boolean hasProgrammingRight) {
        super(repository, safeProvider, execution, hasProgrammingRight);
    }

    public int countExtensions() {
        return ((LocalExtensionRepository)this.getWrapped()).countExtensions();
    }

    public LocalExtension getLocalExtension(ExtensionId extensionId) {
        return (LocalExtension)this.safe(((LocalExtensionRepository)this.getWrapped()).getLocalExtension(extensionId));
    }

    public Collection<LocalExtension> getLocalExtensions() {
        return (Collection)this.safe(((LocalExtensionRepository)this.getWrapped()).getLocalExtensions());
    }

    public LocalExtension storeExtension(Extension extension) {
        if (!this.hasProgrammingRight) {
            this.setError(new UnsupportedOperationException("Operation forbidden in script proxy"));
            return null;
        }
        this.setError(null);
        try {
            return (LocalExtension)this.safe(((LocalExtensionRepository)this.getWrapped()).storeExtension(extension));
        }
        catch (LocalExtensionRepositoryException e) {
            this.setError((Exception)((Object)e));
            return null;
        }
    }

    public void removeExtension(LocalExtension extension) {
        if (!this.hasProgrammingRight) {
            this.setError(new UnsupportedOperationException("Operation forbidden in script proxy"));
        }
        this.setError(null);
        try {
            ((LocalExtensionRepository)this.getWrapped()).removeExtension(extension);
        }
        catch (ResolveException e) {
            this.setError((Exception)((Object)e));
        }
    }

    public LocalExtension resolve(ExtensionDependency extensionDependency) {
        return (LocalExtension)super.resolve(extensionDependency);
    }

    public LocalExtension resolve(ExtensionId extensionId) {
        return (LocalExtension)super.resolve(extensionId);
    }

    public Collection<LocalExtension> getLocalExtensionVersions(String id) {
        return (Collection)this.safe(((LocalExtensionRepository)this.getWrapped()).getLocalExtensionVersions(id));
    }

    public void setProperties(LocalExtension localExtension, Map<String, Object> properties) {
        if (!this.hasProgrammingRight) {
            this.setError(new UnsupportedOperationException("Operation forbidden in script proxy"));
        }
        this.setError(null);
        try {
            ((LocalExtensionRepository)this.getWrapped()).setProperties(localExtension, properties);
        }
        catch (LocalExtensionRepositoryException e) {
            this.setError((Exception)((Object)e));
        }
    }
}

