/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.versioncheck.internal;

import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.extension.versioncheck.ExtensionVersionCheckConfiguration;

@Component
@Singleton
public class DefaultVersionCheckConfiguration
implements ExtensionVersionCheckConfiguration {
    private static final String CONFIGURATION_PREFIX = "extension.versioncheck.";
    private static final String ENVIRONMENT_CONFIGURATION_PREFIX = "extension.versioncheck.environment.";
    @Inject
    private ConfigurationSource configurationSource;

    @Override
    public boolean isEnvironmentCheckEnabled() {
        return (Boolean)this.configurationSource.getProperty("extension.versioncheck.environment.enabled", (Object)false);
    }

    @Override
    public long environmentCheckInterval() {
        return ((Integer)this.configurationSource.getProperty("extension.versioncheck.environment.interval", (Object)3600)).intValue();
    }

    @Override
    public Pattern allowedEnvironmentVersions() {
        String allowedVersions = (String)this.configurationSource.getProperty("extension.versioncheck.environment.allowedVersions", (Object)"");
        return allowedVersions.isEmpty() ? null : Pattern.compile(allowedVersions);
    }
}

